package jp.sourceforge.dvibrowser.dvicore.image.pnm;
/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;


public class PnmBitAsciiFilter
extends AbstractPnmAsciiFilter
{
  public PnmBitAsciiFilter(InputStream in) {
    super(in);
  }
  
  protected synchronized byte [] fillBuffer() throws IOException
  {
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    String line = reader.readLine();
    if (line == null) {
      throw new IOException("EOF detected while reading the input");
    }
    while (line.length() > 0) {
      String d = null;
      if (line.length() >= 8) {
        d = line.substring(0, 8);
        line = line.substring(8);
      } else {
        d = (line + "0000000").substring(0, 8);
        line = "";
      }
      try {
        baos.write(Integer.parseInt(d, 2));
      } catch (NumberFormatException e) {
        throw new IOException("Input format error: data is not binary: " + line);
      }
    }
    if (baos.size() == 0) {
      throw new IOException("EOF detected while reading the input");
    }
    return baos.toByteArray();
  }
}
