/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.doc;

import jp.sourceforge.dvibrowser.dvicore.DviByteRange;
import jp.sourceforge.dvibrowser.dvicore.DviException;
import jp.sourceforge.dvibrowser.dvicore.DviFontTable;
import jp.sourceforge.dvibrowser.dvicore.DviObject;
import jp.sourceforge.dvibrowser.dvicore.DviUnit;
import jp.sourceforge.dvibrowser.dvicore.api.DviDocument;
import jp.sourceforge.dvibrowser.dvicore.api.DviInput;
import jp.sourceforge.dvibrowser.dvicore.api.DviPage;

public final class DefaultDviPage
extends DviObject
implements DviPage//, java.io.Serializable
{
  private final DviDocument doc;
  private final long bop;
  private final long eop;
  private final int pageNum;

  DefaultDviPage(DviDocument doc, int pageNum, long bop, long eop)
  {
    super(doc);
    this.doc = doc;
    this.pageNum = pageNum;
    this.bop = bop;
    this.eop = eop;
  }

  public DviDocument getDocument() { return doc; }
  public DviUnit getDviUnit() throws DviException { return doc.getDviUnit(); }
  public DviFontTable getFontTable() throws DviException { return doc.getFontTable(); }
  public DviByteRange range() { return new DviByteRange(bop, eop); }
  public int getPageNumber() { return pageNum; }

  public DviInput getInput()
  throws DviException
  {
    return doc.getInput(bop, eop);
  }
  
  public String toString()
  {
    return getClass().getName() + "[pageNum=" + pageNum + ",bop=" + bop + ",eop=" + eop + "]";
  }

  public long getDataSize() throws DviException
  {
    return (eop - bop + 1);
  }

  public DviInput getInput(long start, long end) throws DviException
  {
    return doc.getInput(bop + start, bop + end);
  }
}