/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.render;

import dvi.DviException;
import dvi.DviRect;
import dvi.DviResolution;
import dvi.api.BinaryDevice;

public class BoundingBoxComputer
extends AbstractDevice
implements BinaryDevice
{
  private DviRect bbox = DviRect.EMPTY;
  public BoundingBoxComputer(DviResolution res)
  {
    super(res);
  }

  public DviRect getBoundingBox()
  throws DviException
  {
    return bbox;
  }

  public void begin()
  throws DviException
  {
  }

  public void end()
  throws DviException
  {
  }

  public boolean beginRaster(int w, int h)
  throws DviException
  {
    bbox = bbox.union(new DviRect(getReferencePoint(), w, h));
    return false;
  }

  public void endRaster()
  throws DviException
  {
  }

  public void beginLine()
  throws DviException
  {
    // not called.
  }

  public void endLine(int repeat)
  throws DviException
  {
    // not called.
  }

  public void putBits(int count, boolean paintFlag)
  throws DviException
  {
    // not called.
  }
}
