package dvi.image.pnm;
/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;

import dvi.DviRect;
import dvi.DviSize;
import dvi.image.split.SplitImageWriter;
public class PbmSplitter
extends AbstractPnmSplitter
{
//  private static final Logger LOGGER = Logger.getLogger(PbmSplitter.class
//      .getName());
  public PbmSplitter(DviSize unitSize, SplitImageWriter imageWriter)
  {
    super(unitSize, imageWriter);
  }
  
  @Override
  protected byte [] createLineBuffer()
  {
    return new byte [(header.getWidth() + 7) / 8];
  }
  
  @Override
  protected BufferedImage createBufferedImage(DviRect box)
  {
    final byte[] colors = {(byte)255, 0};
    final IndexColorModel cm = new IndexColorModel(1,2,colors,colors,colors);
    return new BufferedImage(box.width(), box.height(), BufferedImage.TYPE_BYTE_BINARY, cm);
  }
  
  @Override
  protected int copyLineToDataBuffer(byte [] buf, int x, DviRect box, int i, DataBufferByte data)
  {
    final int uw = (box.width() + 7) /8;
    System.arraycopy(buf, x, data.getData(), i * uw, uw);
    return uw;
  }
}
