/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.font;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

import dvi.DviException;
import dvi.api.CharacterCodeMapper;
import dvi.api.DviContextSupport;
import dvi.api.DviFont;
import dvi.ctx.UnicodeCharacterCodeMapper;
import dvi.util.DviUtils;

// TODO: merge this class with Type1FontResolver
public class TrueTypeFontResolver
extends AbstractDviFontResolver
{
  private static final Logger LOGGER = Logger.getLogger(DviFontResolver.class
      .getName());
  
  private static final CharacterCodeMapper mapper = new UnicodeCharacterCodeMapper();
  
  private String fileExtension = ".ttf";

  public TrueTypeFontResolver(DviContextSupport dcs, LogicalFont logicalFont)
  {
    super(dcs, logicalFont);
  }

  @Override
  protected DviFont createInstanceFromStream(InputStream is) throws DviException
  {
    try {
      Font font = Font.createFont(Font.TRUETYPE_FONT, is);
      return new AWTDynamicPkFont(this, font, mapper);
    } catch (IOException e) {
      DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
      throw new DviException(e);
    } catch (FontFormatException e) {
      DviUtils.logStackTrace(LOGGER, Level.WARNING, e);
      throw new DviException(e);
    }
  }

  @Override
  protected String mapToDviResourceName(LogicalFont logicalFont)
  {
    String name = logicalFont.fontSpec().name();
    return name + fileExtension;
  }

  public void setFileExtension(String fileExtension) {
    this.fileExtension = fileExtension;
  }

  public String getFileExtension() {
    return fileExtension;
  }

}
