/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.font;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

import dvi.DviException;
import dvi.DviObject;
import dvi.api.DviContextSupport;
import dvi.api.DviFont;
import dvi.api.Glyph;

public abstract class AbstractDynamicPkFont
extends DviObject
implements DviFont
{
  private static final long serialVersionUID = -7653383398207050528L;

  public AbstractDynamicPkFont(DviContextSupport dcs)
  throws DviException
  {
    super(dcs);
  }

  // TODO: make the GlyphCache hierarchical so that we can discard
  // glyphs of the same font simultaneously.
  public Glyph getGlyph(LogicalFont lf, int code)
  throws DviException
  {
    String key = lf.fontSpec().toString()
      + "--" + lf.dviUnit().toString() + "--" + lf.resolution().dpi()
      + "--" + code;
    
    Map<String, Glyph> cache = getDviContext().getGlyphCache();
    Glyph glyph = cache.get(key);
    if (glyph != null) return glyph;

    //System.out.println("generating glyph: lf=" + lf + " code=" + code);
    glyph = generatePkGlyph(lf, code);
    cache.put(key, glyph);

    return glyph;
  }
  
  protected abstract PkGlyph generatePkGlyph(LogicalFont lf, int code)
    throws DviException;

  private void writeObject(ObjectOutputStream s)
  throws IOException
  {
    s.defaultWriteObject();
  }

  private void readObject(ObjectInputStream s)
  throws IOException, ClassNotFoundException
  {
    s.defaultReadObject();
  }
}
