/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.cmd;

import dvi.DviUnit;

// immutable.

public class DviPostamble
implements java.io.Serializable
{
  private static final long serialVersionUID = 2018955950810232285L;
  private final int firstBackPointer;
  private final DviUnit dviUnit;
  private final int maxV, maxH;
  private final int maxStackDepth;
  private final int totalPages;

  public DviPostamble(int firstBackPointer, DviUnit dviUnit,
    int maxV, int maxH, int maxStackDepth, int totalPages)
  {
    this.firstBackPointer = firstBackPointer;
    this.dviUnit = dviUnit;
    this.maxV = maxV;
    this.maxH = maxH;
    this.maxStackDepth = maxStackDepth;
    this.totalPages = totalPages;
    checkValues();
  }

  public void checkValues() {}

  public int firstBackPointer() { return firstBackPointer; }
  public DviUnit dviUnit()      { return dviUnit; }
  public int maxV()             { return maxV; }
  public int maxH()             { return maxH; }
  public int maxStackDepth()    { return maxStackDepth; }
  public int totalPages()       { return totalPages; }

  public String toString() {
    return getClass().getName() + "[firstBackPointer=" + firstBackPointer +
               ",dviUnit=" + dviUnit +
               ",max(H,V)=(" + maxH + "," + maxV + ")" +
               ",maxStackDepth=" + maxStackDepth +
               ",totalPages=" + totalPages + "]";
  }

  public boolean equals(Object o) {
    if (o instanceof DviPostamble) {
      DviPostamble p = (DviPostamble) o;
      return p.firstBackPointer == firstBackPointer
          && p.dviUnit.equals(dviUnit)
          && p.maxV == maxV
          && p.maxH == maxH
          && p.maxStackDepth == maxStackDepth
          && p.totalPages == totalPages
          ;
    }
    return false;
  }

  public int hashCode() {
    return firstBackPointer
         + 33*(dviUnit.hashCode()
         + 33*(maxV
         + 33*(maxH
         + 33*(maxStackDepth
         + 33*totalPages
         ))))
         ;
  }
}
