/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi.api;

import dvi.DviException;
import dvi.DviFontSpec;
import dvi.cmd.DviBop;
import dvi.cmd.DviPostPost;
import dvi.cmd.DviPostamble;
import dvi.cmd.DviPreamble;


public interface DviExecutorHandler
{
  void begin(DviExecutorContext ctx) throws DviException;
  void end() throws DviException;

  void doSet(int code) throws DviException;
  void doSetRule(int w, int h) throws DviException;
  void doPut(int code) throws DviException;
  void doPutRule(int w, int h) throws DviException;
  void doNop() throws DviException;

  void doSelectFont(int fn) throws DviException;
  void doDefineFont(int fn, DviFontSpec fs) throws DviException;

  void doPush() throws DviException;
  void doPop() throws DviException;

  void doPre(DviPreamble preamble) throws DviException;
  void doBop(DviBop bop) throws DviException;
  void doEop() throws DviException;
  void doPost(DviPostamble postamble) throws DviException;
  void doPostPost(DviPostPost postPost) throws DviException;

  void doRight(int by) throws DviException;
  void doW(int by) throws DviException;
  void doW0() throws DviException;
  void doX(int by) throws DviException;
  void doX0() throws DviException;

  void doDown(int by) throws DviException;
  void doY(int by) throws DviException;
  void doY0() throws DviException;
  void doZ(int by) throws DviException;
  void doZ0() throws DviException;

  void doSpecial(byte [] xxx) throws DviException;
}