/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package dvi;

public final class DviConstants
{
  private DviConstants() {} // disable instantiation
  
  public static final int            VF_ID_BYTE = 202;
  public static final int         VF_SHORT_CHAR = 0;
  public static final int          VF_LONG_CHAR = 242;

  public static final int       TFM_ID_YOKOGUMI = 11;
  public static final int       TFM_ID_TATEGUMI = 9;

  public static final int           DVI_ID_BYTE = 2;
  public static final int  DVI_ID_BYTE_TATEGUMI = 3;
  public static final int           DVI_TRAILER = 223;

  public static final double        MM_PER_INCH = 25.4;
  public static final double     POINT_PER_INCH = 72.27;
  public static final int           DEFAULT_NUM = 25400000;
  public static final int           DEFAULT_DEN = 7227 * 65536;
  public static final int           DEFAULT_MAG = 1000;

  public static final int UNDEFINED_FONT_NUMBER = -1;
}
