/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore.api;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

import jp.sourceforge.dvibrowser.dvicore.DviException;
import jp.sourceforge.dvibrowser.dvicore.DviFontSpec;
import jp.sourceforge.dvibrowser.dvicore.DviPaperSize;
import jp.sourceforge.dvibrowser.dvicore.DviResolution;
import jp.sourceforge.dvibrowser.dvicore.MetafontMode;
import jp.sourceforge.dvibrowser.dvicore.ctx.DviToolkit;
import jp.sourceforge.dvibrowser.dvicore.font.LogicalFont;
import jp.sourceforge.dvibrowser.dvicore.util.progress.ProgressRecorder;


public interface DviContext
extends DviExecutor, DviContextSupport
{
  DviResolution getDefaultResolution() throws DviException;
  MetafontMode getDefaultMetafontMode() throws DviException;
  
  DviPaperSize getDefaultPaperSize() throws DviException;
  DviPaperSize findPaperSizeByName(String name) throws DviException;
  DviPaperSize [] listPaperSizes() throws DviException;
  
  URL getDviResource(String filename) throws DviException;
  
  File getCacheDirectory() throws DviException;
  File getTemporaryDirectory() throws DviException;
  String getExecutableName(String name) throws DviException;
  
  Map<String, Glyph> getGlyphCache() throws DviException;
  CharacterCodeMapper getCharacterCodeMapper(LogicalFont logicalFont) throws DviException;
  DviExecutor newDviExecutor() throws DviException;
  DevicePainter newDevicePainter() throws DviException;
  DviDocument openDviDocument(File file) throws DviException;
  DviDocument openDviDocument(URL url) throws DviException;
  DviDocument openDviDocument(InputStream is) throws DviException;
  DviFont findDviFont(LogicalFont logicalFont) throws DviException;
  FullMetrics findDviFullMetrics(DviFontSpec fontSpec) throws DviException;
  SimpleMetrics findDviSimpleMetrics(DviFontSpec fontSpec) throws DviException;
  LogicalFont mapLogicalFont(LogicalFont logicalFont) throws DviException;
  
  ProgressRecorder getProgressRecorder();
  DviToolkit getDviToolkit();
}
