/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
package jp.sourceforge.dvibrowser.dvicore;

// TOOD: implement the default values.
public final class MetafontMode {
  public static final MetafontMode FALLBACK_600DPI = new MetafontMode("ljfour", 600);
  public static final MetafontMode FALLBACK_400DPI = new MetafontMode("agfatfzz", 400);
  public static final MetafontMode FALLBACK = FALLBACK_600DPI;
  private final String mode;
  private final int bdpi;

  public MetafontMode(String mode, int bdpi)
  {
    this.mode = mode;
    this.bdpi = bdpi;
  }

  public String getMode() {
    return mode;
  }

  public int getBdpi() {
    return bdpi;
  }
  
  public int hashCode()
  {
    return mode.hashCode() + 33 * bdpi;
  }
  
  public boolean equals(Object o)
  {
    if (!(o instanceof MetafontMode)) {
      return false;
    }
    MetafontMode mm = (MetafontMode) o;
    return (mm.mode.equals(mode) && mm.bdpi == mm.bdpi);
  }
  
  public String toString() {
    return getClass().getName() + "[mode=" + mode + ",bdpi=" + bdpi + "]";
  }
}
