/*
 * Copyright (c) 2009, Takeyuki Nagao
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the
 * following conditions are met:
 * 
 *  * Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer in the documentation and/or other
 *    materials provided with the distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */

package jp.sourceforge.dvibrowser.dvicore;

// immutable.

public class DviPaperSize
implements java.io.Serializable
{
  private static final long serialVersionUID = 4593375448502371177L;
  public static final DviPaperSize UNBOUNDED = new DviPaperSize(Double.MAX_VALUE, Double.MAX_VALUE, "unbounded");
  public static final DviPaperSize CROP_TO_WIDTH = new DviPaperSize(Double.MAX_VALUE, Double.MAX_VALUE, "crop-to-width");
  public static final DviPaperSize CROP_TO_HEIGHT = new DviPaperSize(Double.MAX_VALUE, Double.MAX_VALUE, "crop-to-height");
  public static final DviPaperSize CROP_TO_BOTH = new DviPaperSize(Double.MAX_VALUE, Double.MAX_VALUE, "crop-to-both");
  public static final DviPaperSize FALLBACK = new DviPaperSize(210.0, 297.0, "A4(fallback)");
;
  private final double w_mm;
  private final double h_mm;
  private final String desc;

  public DviPaperSize(double w_mm, double h_mm, String desc) {
    this.w_mm = w_mm;
    this.h_mm = h_mm;
    this.desc = desc;
  }

  public double widthInMM() { return w_mm; }
  public double heightInMM() { return h_mm; }

  public int widthInDots(DviResolution res) {
    return (int) Math.ceil(res.actualDpi() * w_mm / DviConstants.MM_PER_INCH);
  }
  public int heightInDots(DviResolution res) {
    return (int) Math.ceil(res.actualDpi() * h_mm / DviConstants.MM_PER_INCH);
  }
  
  public DviRect toBoundingBox(DviResolution res)
  {
    return new DviRect
    (0, 0, widthInDots(res), heightInDots(res));
  }

  public String description() { return desc; }

  public String toString() {
    return "PaperSize"
           + "{" + w_mm + "mm x " + h_mm + " mm"
           + " desc=" + desc;
  }

  public boolean equals(Object obj) {
    if (obj instanceof DviPaperSize) {
      DviPaperSize a = (DviPaperSize) obj;
      return a.w_mm == w_mm
          && a.h_mm == h_mm
          && desc.equals(a.desc)
          ;
    }
    return false;
  }

  public int hashCode() {
    return (int)(desc.hashCode() + 33*(w_mm + 33*h_mm));
  }
}
