﻿//  Copyright (c) 2010-2012, www.dvgtu.org
//  All rights reserved.

//  Redistribution and use in source and binary forms, with or without modification, 
//  are permitted provided that the following conditions are met:

//  * Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer. 
//  * Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution. 

//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
//  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
//  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
//  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
//  POSSIBILITY OF SUCH DAMAGE.
// $Id: TabControlEx.cs 113 2011-10-23 14:35:46Z takeshich $
//http://www.pc.zaq.jp/tznote/cs/cs_tabControl_001.htmlより取得

using System;
using System.Drawing;
using System.Windows.Forms;

namespace dvgtuViewer
{
	/// <summary>
	/// Description of TabControlEx.
	/// </summary>
	public class TabControlEx : TabControl
	{
		// コンストラクタ
		public TabControlEx()
		{
		}
		
        public event EventHandler TabCloseButtonClick;

        // タブの閉じるボタンクリックイベント
        protected void OnCloseButtonClick(EventArgs e) {
            //MessageBox.Show("タブの閉じるボタンが押されたよ！");
            
            if (this.TabCloseButtonClick != null) {
                this.TabCloseButtonClick(this, e);
            }
        }

        // OnMouseUp
        protected override void OnMouseUp(MouseEventArgs e) {
            base.OnMouseUp(e);
            Point pt = new Point(e.X, e.Y);
            Rectangle rect = this.GetTabCloseButtonRect(pt);
            if (rect.Contains(pt)) {
                this.OnCloseButtonClick(new EventArgs());
                this.Invalidate(rect);
            }
        }

        // タブの閉じるボタン場所を取得
        private Rectangle GetTabCloseButtonRect(Point pt) {
            Rectangle rect;
            for (int i = 0; i < base.TabCount; i++) {
                rect = this.GetTabCloseButtonRect(i);
                if (rect.Contains(pt)) {
                    return rect;
                }
            }
            return Rectangle.Empty;
        }
        

        // タブの閉じるボタン場所を取得
        private Rectangle GetTabCloseButtonRect(int index) {
            Rectangle rect = this.GetTabRect(index);
            rect.X = rect.Right - 20;
            //rect.Y = rect.Top + 2;
            rect.Y = rect.Top;
            rect.Width = 16;
            rect.Height = 16;

            return rect;
        }

        // タブに閉じるボタンを描画
        private void DrawTabCloseButton() {
            Graphics g = this.CreateGraphics();
            Rectangle rect = Rectangle.Empty;
            Point pt = this.PointToClient(Cursor.Position);
            //最初のタブは描画しないので、0からではなく、1から
            for (int i = 1; i < this.TabPages.Count; i++) {
                rect = this.GetTabCloseButtonRect(i);
                // 閉じるボタン描画
                ControlPaint.DrawCaptionButton(g, rect, CaptionButton.Close, ButtonState.Flat);
            }
            g = null;
        }

        // WndProc
        protected override void WndProc(ref Message m) {
            base.WndProc(ref m);
            switch (m.Msg) {
                case 15:
                    this.DrawTabCloseButton();
                    break;
                default:
                    break;
            }
        }
	}
}
