﻿//  Copyright (c) 2010-2012, www.dvgtu.org
//  All rights reserved.

//  Redistribution and use in source and binary forms, with or without modification, 
//  are permitted provided that the following conditions are met:

//  * Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer. 
//  * Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution. 

//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
//  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
//  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
//  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
//  POSSIBILITY OF SUCH DAMAGE.
// $Id: Settings.cs 115 2011-10-29 14:01:18Z takeshich $

using System;
using System.IO;
using System.Reflection;
using System.Runtime.Serialization;
using System.Windows.Forms;
using System.Drawing;
using System.Collections.Generic;
using OpenMetaverse;
using System.Collections;

namespace dvgtuViewer
{
	/// <summary>
	/// Settings
	/// </summary>
	
	
[Serializable()]
public class Settings
{
	//ログイン時の設定を保存するフィールド
	private string firstName;
	private string lastName;
	private string customUri;
	private string password;
	private string author;
	private string userAgent;
	private string userAgentVersion;
	private string startLocation;
	private int gridType;
	private string simName;
	private string simX;
	private string simY;
	private string simZ;
	
	//設定画面の値を保存するフィールド
	private string chatFont;
	private int ownAvatarColor;
	private int normalAvatarColor;
	private int extraAvatarColor;
	private ArrayList extraAvatar;
	
	public ArrayList ExtraAvatar
	{
		get { return extraAvatar; }
		set { extraAvatar = value; }
	}
	
	public string ChatFont
	{
		get { return chatFont; }
		set { chatFont = value; }
	}
	
	public int OwnAvatarColor
	{
		get { return ownAvatarColor; }
		set { ownAvatarColor = value; }
	}
		
	public int NormalAvatarColor
	{
		get { return normalAvatarColor; }
		set { normalAvatarColor = value; }
	}
	
	public int ExtraAvatarColor
	{
		get { return extraAvatarColor; }
		set { extraAvatarColor = value; }
	}
	
	public string FirstName
	{
		get { return firstName; }
		set { firstName = value; }
	}

	public string LastName
	{
		get { return lastName; }
		set { lastName = value; }
	}
	
	public string CustomUri
	{
		get { return customUri; }
		set { customUri = value;}
	}

	public string Password
	{
		get { return password; }
		set { password = value; }
	}

	public string UserAgent
	{
		get { return userAgent; }
		set { userAgent = value; }
	}

	public string Author
	{
		get { return author; }
		set { author = value; }
	}
	
	public string UserAgentVesion
	{
		get { return userAgentVersion; }
		set { userAgentVersion = value; }
	}
	
	public string StartLocation
	{
		get { return startLocation; }
		set { startLocation = value; }
	}
	
	public int GridType
	{
		get { return gridType; }
		set { gridType = value; }
	}
	
	public string SimName
	{
		get { return simName; }
		set { simName = value; }
	}
	
	public string SimX
	{
		get { return simX; }
		set { simX = value; }
	}
	
	public string SimY
	{
		get { return simY; }
		set { simY = value; }
	}
	
	public string SimZ
	{
		get { return simZ; }
		set { simZ = value; }
	}
	
	//コンストラクタ
	public Settings()
	{
		firstName = string.Empty;
		lastName = string.Empty;
		customUri = string.Empty;
		password = string.Empty;
		author = string.Empty;
		userAgent = string.Empty;
		userAgentVersion = string.Empty;
		startLocation = string.Empty;
		gridType = 0;
		simName = string.Empty;
		simX = string.Empty;
		simY = string.Empty;
		simZ = string.Empty;
		
		chatFont = string.Empty;
		ownAvatarColor = Color.Pink.ToArgb();
		normalAvatarColor = Color.Tomato.ToArgb();
		extraAvatarColor = Color.Yellow.ToArgb();
		extraAvatar = new ArrayList();
    }

	//Settingsクラスのただ一つのインスタンス
	[NonSerialized()]
	private static Settings _instance;
	
	[System.Xml.Serialization.XmlIgnore]
	public static Settings Instance
	{
	get
		{
			if (_instance == null)
				_instance = new Settings();
				return _instance;
		}
		set {_instance = value;}
	}
	
	

	/// <summary>
	/// 設定をXMLファイルから読み込み復元する
	/// </summary>
	public static void LoadFromXmlFile()
	{
		Assembly asm = Assembly.GetEntryAssembly();
    	string fullPath = asm.Location;

    	// 2. フル・パスからディレクトリ・パス部分を抽出する
    	string dirPath = Path.GetDirectoryName(fullPath);
		string path =  dirPath + System.IO.Path.DirectorySeparatorChar + 
			"Settings.xml";

		FileStream fs = new FileStream(path,
			FileMode.Open,
			FileAccess.Read);
		System.Xml.Serialization.XmlSerializer xs =
			new System.Xml.Serialization.XmlSerializer(
			typeof(Settings));
		//読み込んで逆シリアル化する
		object obj = xs.Deserialize(fs);
		fs.Close();

		Instance = (Settings) obj;
	}

	/// <summary>
	/// 現在の設定をXMLファイルに保存する
	/// </summary>
	public static void SaveToXmlFile()
	{
		Assembly asm = Assembly.GetEntryAssembly();
    	string fullPath = asm.Location;

    	// 2. フル・パスからディレクトリ・パス部分を抽出する
    	string dirPath = Path.GetDirectoryName(fullPath);
		string path =  dirPath + System.IO.Path.DirectorySeparatorChar +
			"Settings.xml";
		
		FileStream fs = new FileStream(path,
			FileMode.Create,
			FileAccess.Write);
		System.Xml.Serialization.XmlSerializer xs =
			new System.Xml.Serialization.XmlSerializer(
			typeof(Settings));
		//シリアル化して書き込む
		xs.Serialize(fs, Instance);
		fs.Close();
	}

}
}
