﻿//  Copyright (c) 2010-2012, www.dvgtu.org
//  All rights reserved.

//  Redistribution and use in source and binary forms, with or without modification, 
//  are permitted provided that the following conditions are met:

//  * Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer. 
//  * Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution. 

//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
//  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
//  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
//  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
//  POSSIBILITY OF SUCH DAMAGE.
// $Id: MapForm.cs 132 2011-11-11 14:18:46Z takeshich $

using System;
using System.Collections;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using System.Reflection;
using System.Collections.Generic;
using WeifenLuo.WinFormsUI.Docking;
using OpenMetaverse;
using OpenMetaverse.Assets;
using dvgtuViewer.SLNetworkComm;
using System.Threading;
using CSJ2K;
using System.Drawing.Imaging;

namespace dvgtuViewer
{
	/// <summary>
	/// Description of MapForm.
	/// </summary>
	public partial class MapForm : WeifenLuo.WinFormsUI.Docking.DockContent
	{
		private DvgtuInstance dvgtuInstance;
		private GridClient Client{ get { return dvgtuInstance.Client; } }
		private SLNetCom NetCom{ get { return dvgtuInstance.Netcom; } }
	
		private Dictionary<string, UUID> ExtraName2Key = new Dictionary<string, UUID>();
		private Dictionary<string, UUID> Name2Key = new Dictionary<string, UUID>();
		
		private Image pSimMap = null;
		
		private TextureDownloadCallback TextureDownloadCallback;
		
		private ArrayList ExtraAvatarListArray = new ArrayList();
		private int OwnAvatarColorValue;
		private int NormalAvatarColorValue;
		private int ExtraAvatarColorValue;
		
		public MapForm(DvgtuInstance dvgtuInstance)
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
			this.dvgtuInstance = dvgtuInstance;
			this.Load += new EventHandler(MapForm_Load);
			
		}
		void MapForm_Load(object sender, EventArgs e)
		{
			//NetCom.NetcomSync = this;

			//SimMapDraw();
			//SimInfoDraw();
			timer1.Interval = 2000;
			timer1.Enabled = true;
			timer1.Start();
			
			//設定ファイルの読み込み
			Settings.LoadFromXmlFile();
				
			foreach(string avauuid in Settings.Instance.ExtraAvatar){
				ExtraAvatarListArray.Add((UUID)avauuid);
			}
			
			OwnAvatarColorValue = Settings.Instance.OwnAvatarColor;
			NormalAvatarColorValue = Settings.Instance.NormalAvatarColor;
			ExtraAvatarColorValue = Settings.Instance.ExtraAvatarColor;
			
			NetCom.TeleportStatusChanged += new EventHandler<OpenMetaverse.TeleportEventArgs>(NetCom_TeleportStatusChanged);

			TextureDownloadCallback += new TextureDownloadCallback(SimTextureDownloadCallback);
			
			
			
		}
		
		void  MapForm_Disposed(object sender, EventArgs e){
			NetCom.TeleportStatusChanged -= new EventHandler<OpenMetaverse.TeleportEventArgs>(NetCom_TeleportStatusChanged);
		}

		void NetCom_TeleportStatusChanged(object sender,OpenMetaverse.TeleportEventArgs e)
		{
			switch (e.Status){
				case TeleportStatus.Finished:
					pSimMap = null;
					//SimMapDraw();
					//DrawMapInfo();
					break;
				default:
					break;
				
			}
		}
		

		void SimTextureDownloadCallback(TextureRequestState state, AssetTexture assetTexture)
		{
			try
			{

				if (state != TextureRequestState.NotFound || state != TextureRequestState.Timeout)
				{

					pSimMap = J2kImage.FromBytes(assetTexture.AssetData);
					
//					//for debug
//					Assembly asm = Assembly.GetEntryAssembly();
//					string fullPath = asm.Location;
//				
//					//フル・パスからディレクトリ・パス部分を抽出する
//					string dirPath = Path.GetDirectoryName(fullPath);
//					string path =  dirPath + "\\simmmap.jpg";
//					Bitmap bitmap = new Bitmap(J2kImage.FromBytes(assetTexture.AssetData));
//					bitmap.Save(path);
				}	

			}
			catch(Exception ex)
			{
				Logger.Log("MapForm_SimTextureDownloadCallback" + ex.Message,OpenMetaverse.Helpers.LogLevel.Error);
			}
		}
		
		public void SimMapDraw()
		{
			try{
						
				string SimName = Client.Network.CurrentSim.Name;
	
				//現在のSIMを得る
				GridRegion gRegion;
				Client.Grid.GetGridRegion(SimName, GridLayerType.Objects , out gRegion);
				//SIMのイメージをリクエストする
				Client.Assets.RequestImage(gRegion.MapImageID,ImageType.Baked,SimTextureDownloadCallback);
			}
			catch(Exception ex)
			{
				Logger.Log("MapForm_SimMapDraw" +  ex.Message, Helpers.LogLevel.Error);
			}
		}
		
		private void DrawMapInfo(){
			Bitmap bufferbmp = new Bitmap(256,256);
			AvatorDraw(pSimMap,bufferbmp,this.picDraw);
			//SimInfoDraw();
		}
		
		void AvatorDraw(Image SimMap,System.Drawing.Bitmap buffermap,System.Windows.Forms.PictureBox picDraw){

			//線(Pen)の色を設定
			Pen penRed = new Pen(Color.Red);
			
			//塗りつぶす色を設定
			SolidBrush brAvator = new SolidBrush(Color.FromArgb(NormalAvatarColorValue)); //アバターの色
			SolidBrush brExtraAvator = new SolidBrush(Color.FromArgb(ExtraAvatarColorValue)); //特別な人の色
			SolidBrush brOwn = new SolidBrush(Color.FromArgb(OwnAvatarColorValue)); //自分の色
			
			//描画エリアの左端の値を求める
			Rectangle rc = picDraw.ClientRectangle;
			
			//描画の自分以外のアバターの三角形の辺
			const int Avahen = 8;
			const int Ownhen = 10;
			
			//円の範囲を指定(Say)
			const int ChatRange = 20;
			
			int reversePointY = 256;

			
			//メモリ内で描画する
			using(Graphics grhs  = Graphics.FromImage(buffermap)){
					
					//SimのMINIMapを描画
					if (SimMap != null){
						grhs.DrawImage(SimMap,rc,0,0,256,256,GraphicsUnit.Pixel);
					}
					
					//Avatarを描画
					InternalDictionary<UUID, Vector3> AvaData = Client.Network.CurrentSim.AvatarPositions;
					AvaData.ForEach(delegate(KeyValuePair<UUID, Vector3> AvaKvp)
						{
			         			//extraAvaNameを調べる
								bool flgExAva = false;
								
								foreach(UUID AvatarUUID in ExtraAvatarListArray){
									if (AvatarUUID == AvaKvp.Key) flgExAva = true;
								}
								
//								foreach(KeyValuePair<string, UUID> exKvp in ExtraName2Key)
//								{
//									if (ExtraName2Key.ContainsValue(AvaKvp.Key)) flgExAva = true;
//								}
			                	
								//Avatorの位置を三角形で描画
								//Avatorの位置を求める
								int AvaPosX = (int)AvaKvp.Value.X;
								int AvaPosY = (int)AvaKvp.Value.Y;
								AvaPosY = reversePointY - AvaPosY;
								
								//三角形を構成
								Point[] PosAvator = TriangleDraw(AvaPosX,AvaPosY,Avahen);
								if (flgExAva){
									grhs.FillPolygon(brExtraAvator,PosAvator);
								}
								else{
									if(Client.Self.AgentID != AvaKvp.Key){
										grhs.FillPolygon(brAvator,PosAvator);
									}
								}
						});
					

					//自分の位置を三角形で描画
					//自分の位置を求める
					int PosX = (int)Client.Self.SimPosition.X;
					int PosY = (int)Client.Self.SimPosition.Y;
					PosY = reversePointY - PosY;
					
					//三角形を構成
					Point[] PosSelf = TriangleDraw(PosX,PosY,Ownhen);
					grhs.FillPolygon(brOwn,PosSelf);
					
					//Say範囲を円で描画
					//円の中心座標より、左上の座標を求める
					Rectangle Sayrc = new Rectangle(PosX - ChatRange,
					                                PosY - ChatRange,
					                                ChatRange*2,ChatRange*2);
					grhs.DrawEllipse(penRed,Sayrc);
					
					//クリア
					grhs.Dispose();
				}
			
				//return buffermap;
				picDraw.BackgroundImage = buffermap;
		}
		
		//正三角形の中点のX,Yの座標と辺の長さを与えて、正三角形の頂点の座標を出す
		Point[] TriangleDraw(int PosX,int PosY,int hen){
				Point[] PosSelf = new Point[3];
				PosSelf[0].X = PosX;
				PosSelf[0].Y = PosY-(hen/2);
				PosSelf[1].X = PosX-(hen/2);
				PosSelf[1].Y = PosY+(hen/2);
				PosSelf[2].X = PosX+(hen/2);
				PosSelf[2].Y = PosY+(hen/2);
				
				return PosSelf;
		}

		void Timer1Tick(object sender, EventArgs e)
		{
			if (!NetCom.IsLoggingIn) return;
			if (pSimMap == null){
				SimMapDraw();
			}
			DrawMapInfo();
		}
		
		void BtnMoveDownClick(object sender, EventArgs e)
		{
			Bitmap bufferbmp = new Bitmap(256,256);
			float MoveLength = 1.5f;
			float MovePointY = Client.Self.SimPosition.Y - MoveLength;
			
			Vector3 DistPos;
			DistPos.X = Client.Self.SimPosition.X;
			DistPos.Y = MovePointY;
			DistPos.Z = Client.Self.SimPosition.Z;


			Client.Self.Movement.TurnToward(DistPos);
			Client.Self.Movement.FinishAnim = true;
			Client.Self.AutoPilotLocal((int)Math.Round(Client.Self.SimPosition.X),(int)Math.Round(MovePointY),(int)Math.Round(Client.Self.SimPosition.Z));
			AvatorDraw(pSimMap,bufferbmp,this.picDraw);
		}
		
		void BtnMoveUpClick(object sender, EventArgs e)
		{
			Bitmap bufferbmp = new Bitmap(256,256);
			float MoveLength = 1.5f;
			float MovePointY = Client.Self.SimPosition.Y + MoveLength;
			
			Vector3 DistPos;
			DistPos.X = Client.Self.SimPosition.X;
			DistPos.Y = MovePointY;
			DistPos.Z = Client.Self.SimPosition.Z;
			
			Client.Self.Movement.TurnToward(DistPos);
			Client.Self.Movement.FinishAnim = true;
			Client.Self.AutoPilotLocal((int)Math.Round(Client.Self.SimPosition.X),(int)Math.Round(MovePointY),(int)Math.Round(Client.Self.SimPosition.Z));
			AvatorDraw(pSimMap,bufferbmp,this.picDraw);
		}
		
		void BtnMoveRightClick(object sender, EventArgs e)
		{
			Bitmap bufferbmp = new Bitmap(256,256);
			float MoveLength = 1.5f;
			float MovePointX = Client.Self.SimPosition.X + MoveLength;
						
			Vector3 DistPos;
			DistPos.X = MovePointX;
			DistPos.Y = Client.Self.SimPosition.Y;
			DistPos.Z = Client.Self.SimPosition.Z;

			Client.Self.Movement.TurnToward(DistPos);
			Client.Self.Movement.FinishAnim = true;

			Client.Self.AutoPilotLocal((int)Math.Round(MovePointX),(int)Math.Round(Client.Self.SimPosition.Y),(int)Math.Round(Client.Self.SimPosition.Z));
			AvatorDraw(pSimMap,bufferbmp,this.picDraw);
		}
		
		void BtnMoveleftClick(object sender, EventArgs e)
		{
			Bitmap bufferbmp = new Bitmap(256,256);
			float MoveLength = 1.5f;
			float MovePointX = Client.Self.SimPosition.X - MoveLength;
			
			Vector3 DistPos;
			DistPos.X = MovePointX;
			DistPos.Y = Client.Self.SimPosition.Y;
			DistPos.Z = Client.Self.SimPosition.Z;

			Client.Self.Movement.TurnToward(DistPos);
			Client.Self.Movement.FinishAnim = true;

			Client.Self.AutoPilotLocal((int)Math.Round(MovePointX),(int)Math.Round(Client.Self.SimPosition.Y),(int)Math.Round(Client.Self.SimPosition.Z));
			AvatorDraw(pSimMap,bufferbmp,this.picDraw);
		}
		
		void SameSimeTeleport(int PointX,int PointY){
			//pictObjectのrectangleの値をとる。
			//それを起点とし、座標を求める
			//256x256のマップであるということを前提とするため、Y軸の値を反転させる値をもつ

			
			//起点の値(intOrigPointX,intOrigPointY)
			//int intOrigPointX = PointX ;
			//int intOrigPointY = PointY ;
			
			//pictObjectのクリックされた場所の座標を取る
			//teleportするための座標を得る
			
			int reversePointY = 256;
			int DistPointX = PointX;
			int DistPointY = reversePointY - PointY;

			DialogResult result = MessageBox.Show(string.Format("{0}/{1}/{2}/{3} にテレポートしますが、よろしいですか？",
			                                                    Client.Network.CurrentSim.Name,
			                                     				DistPointX.ToString(),
			                                    				DistPointY.ToString(),
			                                     				Client.Self.SimPosition.Z.ToString()),
			                                     				"確認",MessageBoxButtons.OKCancel);
			if (result == DialogResult.Cancel) return;
			NetCom.Teleport(Client.Network.CurrentSim.Name,new Vector3((float)DistPointX,(float)DistPointY,Client.Self.SimPosition.Z));
			
		}
		
		void PicDrawClick(object sender, MouseEventArgs e)
		{
			int ClickPointX = e.X;
			int ClickPointY = e.Y;
			
			if (!NetCom.IsLoggingIn) return;
				
			SameSimeTeleport(ClickPointX,ClickPointY);
		}
		
		void BtnTeleportClick(object sender, EventArgs e)
		{
			string SimName = txtSimName.Text;
			float PointX = (float)numUDX.Value;
			float PointY = (float)numUDY.Value;
			float PointZ = (float)numUDZ.Value;
			
			
			GridRegion region;
			
			if (!NetCom.IsLoggingIn) return;
			
			SimName = BasicUtil.ToTitleCase(SimName);
			txtSimName.Text = SimName;
			
			if (Client.Grid.GetGridRegion(SimName, GridLayerType.Objects,out region))
			{
				NetCom.Teleport(SimName,new Vector3(PointX,PointY,PointZ));
			}
			else
			{
				MessageBox.Show("Sim名が正しくないらしい","注意");
				return;
			}
		}
		
		void ChkTeleportCheckedChanged(object sender, EventArgs e)
		{
			if(chkTeleport.Checked){
				txtSimName.Visible = true;
				numUDX.Visible = true;
				numUDY.Visible = true;
				numUDZ.Visible = true;
				btnTeleport.Visible = true;
			}else{
				txtSimName.Visible = false;
				numUDX.Visible = false;
				numUDY.Visible = false;
				numUDZ.Visible = false;
				btnTeleport.Visible = false;
			}
		}
	}
}
