﻿//  Copyright (c) 2010-2012, www.dvgtu.org
//  All rights reserved.

//  Redistribution and use in source and binary forms, with or without modification, 
//  are permitted provided that the following conditions are met:

//  * Redistributions of source code must retain the above copyright notice, 
//    this list of conditions and the following disclaimer. 
//  * Redistributions in binary form must reproduce the above copyright notice, 
//    this list of conditions and the following disclaimer in the documentation 
//    and/or other materials provided with the distribution. 

//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
//  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
//  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
//  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
//  POSSIBILITY OF SUCH DAMAGE.
// $Id: MainForm.cs 133 2011-11-11 15:24:10Z takeshich $

using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Reflection;
using System.Threading;
using System.Windows.Forms;
using OpenMetaverse;
using dvgtuViewer.SLNetworkComm;
using WeifenLuo.WinFormsUI.Docking;


namespace dvgtuViewer
{
	/// <summary>
	/// Description of MainForm.
	/// </summary>
	public partial class MainForm : Form
	{
		private DvgtuInstance dvgtuInstance;
		private GridClient Client{ get { return dvgtuInstance.Client; } }
		private SLNetCom NetCom{ get { return dvgtuInstance.Netcom; } }

		public MainForm(DvgtuInstance dvgtuInstance)
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
			this.dvgtuInstance = dvgtuInstance;

			LoginParams Lparams = new LoginParams();
			
			dockPanel1.DockRightPortion = 257.0;
//			dockPanel1.AutoScrollMargin = 270;
			
			this.toolStripStatusLabel1.Visible = false;
			this.toolStripStatusLabel2.Visible = false;
			this.toolStripStatusLabel3.Visible = false;
			this.miniMapToolStripMenuItem.Enabled = false;
			this.avatarListToolStripMenuItem.Enabled = false;

			LoginForm loginForm = new LoginForm(dvgtuInstance);
			loginForm.Show(dockPanel1,DockState.Document);
			
			ChatForm chatForm = new ChatForm(dvgtuInstance);
			this.dvgtuInstance.chatForm = chatForm;
			chatForm.Show(dockPanel1,DockState.Document);
			
			loginForm.Activate();

			NetCom.ClientLoginStatus += new EventHandler<LoginProgressEventArgs>(NetCom_ClientLoginStatus);
			NetCom.FriendshipOffered += new EventHandler<OpenMetaverse.FriendshipOfferedEventArgs>(NetCom_FriendshipOffered);
			this.FormClosing += new FormClosingEventHandler(MainForm_FormClosing);
		}

		void NetCom_FriendshipOffered(object sender, OpenMetaverse.FriendshipOfferedEventArgs e)
		{
			//friendshipがきたときメッセージボックスを出し、受諾を問う
			DialogResult result = MessageBox.Show(e.AgentName + "より友達申請あり、受け入れますか？","友達申請",MessageBoxButtons.YesNoCancel);
			switch(result){
					case DialogResult.Yes:
						Client.Friends.AcceptFriendship(e.AgentID,e.SessionID);
						break;
					case DialogResult.No:
						Client.Friends.DeclineFriendship(e.AgentID,e.SessionID);
						break;
					case DialogResult.Cancel:
						break;
			}
		}
		
		void MainForm_Disposed(object sender, EventArgs e)
		{
			NetCom.ClientLoginStatus -= new EventHandler<LoginProgressEventArgs>(NetCom_ClientLoginStatus);
			NetCom.FriendshipOffered -= new EventHandler<OpenMetaverse.FriendshipOfferedEventArgs>(NetCom_FriendshipOffered);
		}

		void MainForm_FormClosing(object sender, FormClosingEventArgs e)
		{
			
			
//			if (timer1 != null){
//				timer1.Stop();
//				timer1.Dispose();
//				timer1 = null;
//			}
			
			switch (e.CloseReason)
    		{
				case CloseReason.ApplicationExitCall:
					if (NetCom.IsLoggedIn){
						NetCom.Logout();
					}
					break;
				case CloseReason.UserClosing:
					if (NetCom.IsLoggedIn){
						//NetCom.ChatOut("にゃっふー",ChatType.Normal,0);
						//NetCom.ChatOut("おちるー",ChatType.Normal,0);
						NetCom.Logout();
					}
					break;
				case CloseReason.WindowsShutDown:
					if (NetCom.IsLoggedIn){
						NetCom.Logout();
					}
					break;
				case CloseReason.TaskManagerClosing:
					if (NetCom.IsLoggedIn){
						NetCom.Logout();
					}
					break;
				default:
					break;

			}

			
		}
		void NetCom_ClientLoginStatus(object sender, LoginProgressEventArgs e)
		{
			
			if (e.Status == LoginStatus.Success){
//				loginForm.Close();

//				Assembly asm = Assembly.GetEntryAssembly();
//				string fullPath = asm.Location;
//
//				//フル・パスからディレクトリ・パス部分を抽出する
//				string dirPath = Path.GetDirectoryName(fullPath);
//				string path =  dirPath + "\\DockSettings.xml";
//				dockPanel1.LoadFromXml(path);
				
				MapForm mapForm = new MapForm(dvgtuInstance);
				this.dvgtuInstance.mapForm = mapForm;
				mapForm.Show(dockPanel1,DockState.DockRight);

				ListForm listForm = new ListForm(dvgtuInstance);
				dvgtuInstance.listForm = listForm;
				listForm.Show(dockPanel1,DockState.DockLeft);
				SimInfoDraw();
				toolStripStatusLabel3.Text = Client.Self.Name;
				
				timer1.Interval = 2000;
				timer1.Enabled = true;
				timer1.Start();
				
				this.toolStripStatusLabel1.Visible = true;
				this.toolStripStatusLabel2.Visible = true;
				this.toolStripStatusLabel3.Visible = true;
			}
		}
		
		void SimInfoDraw()
		{
			string SimOwner = string.Empty;
			
			if (!NetCom.IsLoggedIn) return;
			
			int SimPosX = (int)Client.Self.SimPosition.X;
			int SimPosY = (int)Client.Self.SimPosition.Y;
			int SimPosZ = (int)Client.Self.SimPosition.Z;

//			SIMの
//			名前
//			レーティング
//			オーナー
//			バージョン
//			IPとポート
//			シムのキャパ
//			シムの人数
			
			
			//位置情報と人数
			//string SimCaps = Client.Network.CurrentSim.Caps;
			string SimLocationInfo = string.Format("{0}/{1}/{2}/{3} {4}avatar(s) {5}",
                      Client.Network.CurrentSim.Name,
                      SimPosX.ToString(),
                      SimPosY.ToString(),
                      SimPosZ.ToString(),
                      Client.Network.CurrentSim.AvatarPositions.Count,
                      Client.Network.CurrentSim.Access.ToString());
			string Ld = "L$:" + Client.Self.Balance;
									
			toolStripStatusLabel1.Text = SimLocationInfo;
			toolStripStatusLabel2.Text = Ld;

//			labelSimowner.Text = SimOwner;
//			labelSimVersion.Text = SimVersion;
//			labelSimIpAddress.Text = SimIpAddress + ":" + SimPort;

		}
		
		void LogoutToolStripMenuItemClick(object sender, EventArgs e)
		{
			if (!NetCom.IsLoggedIn) return;
			
			DialogResult result = MessageBox.Show("ログアウトしますよろしいですか？","ログアウト確認",MessageBoxButtons.OKCancel);
			if (result == DialogResult.Cancel) return;
			
			timer1.Stop();
//			NetCom.ChatOut("にゃっふー",ChatType.Normal,0);
//			NetCom.ChatOut("おちるー",ChatType.Normal,0);
			NetCom.Logout();
			
			Assembly asm = Assembly.GetEntryAssembly();
			string fullPath = asm.Location;

			//フル・パスからディレクトリ・パス部分を抽出する
			string dirPath = Path.GetDirectoryName(fullPath);
			string path =  dirPath + "\\DockSettings.xml";
			dockPanel1.SaveAsXml(path);
		}
		
		void ExitToolStripMenuItemClick(object sender, EventArgs e)
		{
			DialogResult result = MessageBox.Show("アプリケーションしますよろしいですか？","終了確認",MessageBoxButtons.OKCancel);
			if (result == DialogResult.Cancel) return;
			
			this.Close();
				
		}
		
		
		
		

		
		
		
		void AboutToolStripMenuItemClick(object sender, EventArgs e)
		{
			AboutForm aboutForm = new AboutForm();
			aboutForm.ShowDialog();
			aboutForm.Dispose();
		}
		
		void PreferenceToolStripMenuItemClick(object sender, EventArgs e)
		{
			SettingForm settingForm = new SettingForm(dvgtuInstance);
			settingForm.ShowDialog();
			settingForm.Dispose();
		}
		
		void Timer1Tick(object sender, EventArgs e)
		{
			if (!NetCom.IsLoggedIn) return;
			SimInfoDraw();
			
			if (dvgtuInstance.mapForm.IsDisposed){
				miniMapToolStripMenuItem.Enabled = true;
			}else{
				miniMapToolStripMenuItem.Enabled = false;
			}
			if (dvgtuInstance.listForm.IsDisposed){
				avatarListToolStripMenuItem.Enabled = true;
			}else{
				avatarListToolStripMenuItem.Enabled = false;
			}
		}
		
		void MiniMapToolStripMenuItemClick(object sender, EventArgs e)
		{
			MapForm mapForm = new MapForm(dvgtuInstance);
			dvgtuInstance.mapForm = mapForm;
			mapForm.Show(dockPanel1,DockState.DockRight);
		}
		
		void AvatarListToolStripMenuItemClick(object sender, EventArgs e)
		{
			ListForm listForm = new ListForm(dvgtuInstance);
			dvgtuInstance.listForm = listForm;
			listForm.Show(dockPanel1,DockState.DockLeft);
		}
		
//		// ウィンドウの名称に対応するDockContentを返す
//		IDockContent GetDockContentFromPersistString( string persistString )
//		{
//		    switch( persistString )
//		    {
//		        case "MapForm":  // GetPersistStringメソッドが返すウィンドウ名称
//		            return this.dockingWindow1;
//		
//		        case "DockingWindowName2":
//		            return this.dockingWindow2;
//		    }
//		    return null;
//		}
	}
}
