using System;
using System.Drawing;
using System.Windows.Forms;

namespace WeifenLuo.WinFormsUI.Docking
{
	internal static class Win32Helper
	{
		public static Control ControlAtPoint(Point pt)
		{
			//vbgtH[̎擾
			System.OperatingSystem os = System.Environment.OSVersion;
			
			if(os.Platform == PlatformID.Win32NT){
				return Control.FromChildHandle(NativeMethods.WindowFromPoint(pt));
			}else
			{
				return null;
			}
			
		}

		public static uint MakeLong(int low, int high)
		{
			return (uint)((high << 16) + low);
		}
	}
}
