#include	"monitor.h"

int	get_server_ip(void)
{
	struct	addrinfo hints, *res;
	struct	addrinfo	*rp;

	struct in_addr addr;
	int err;

	struct	dslogd_table	*dslogd_p, *dslogd_save;

	dslogd_p = dslogd_pnt;
	while (dslogd_p)
	{
		dslogd_save = dslogd_p->next_pnt;
		free (dslogd_p);
		dslogd_p = dslogd_save;
	}

	dslogd_pnt = NULL;

	time(&atime);	
	memset(&hints, 0, sizeof(hints));
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_family = PF_UNSPEC;

	if ((err = getaddrinfo(dslogd_server_fqdn, NULL, &hints, &res)) != 0) {
		fprintf(LogFile, "%24.24s getaddrinf error %s\n", ctime(&atime), strerror(errno));
		fflush (LogFile);
		return 1;
	}

	if (debug_sw) fprintf (LogFile, "%24.24s Current dslogd server address\n", ctime(&atime));
	for (rp = res ; rp != NULL ; rp = rp->ai_next)
	{
		time (&atime);
		addr.s_addr = ((struct sockaddr_in *)(rp->ai_addr))->sin_addr.s_addr;
		if (OwnDslogdIP.s_addr != ((struct sockaddr_in *)(rp->ai_addr))->sin_addr.s_addr)
		{
			dslogd_p = malloc (sizeof(struct dslogd_table));
			if (dslogd_p == NULL)
			{
				time (&atime);
				fprintf (LogFile, "%24.24s malloc error\n", ctime(&atime));
				fflush (LogFile);
				return 1;
			}
			dslogd_p->next_pnt = NULL;
			time(&dslogd_p->up_time);
			dslogd_p->ip_addr.s_addr = ((struct sockaddr_in *)(rp->ai_addr))->sin_addr.s_addr;
			if (dslogd_pnt == NULL)
			{
				dslogd_pnt = dslogd_p;
				dslogd_last = dslogd_p;
			}
			else
			{
				dslogd_last->next_pnt = dslogd_p;
				dslogd_last = dslogd_p;
			}
			if (debug_sw)
			{
				fprintf(LogFile, "%s\n", inet_ntoa(addr));
				fflush (LogFile);
			}
		}
	}
	freeaddrinfo(res);

	return 0;
}

void	hole_punch(void)
{
	char	keep_alive[] ="kp alive";
	struct	dslogd_table	*pnt;
	int	ret;

	pnt = dslogd_pnt;

	while (pnt)
	{
		addr.sin_family = AF_INET;
		addr.sin_port = htons (ex_port);
		addr.sin_addr.s_addr = pnt->ip_addr.s_addr;
		ret = sendto(sock, keep_alive, 8, 0,
			(struct sockaddr *)&addr, sizeof(addr));
		pnt = pnt->next_pnt;
	}
}

