/*
	ҁ@@c@@7m3tjz/ad6gz
	
	ύX@@ 2013.07.08@U^ǗT[o[VXe
*/

#include "dscsd_g3.h"			/* eϐ` */

int	LocalSenderIPcheck(struct sockaddr_in SockAddr);
int	GlobalSenderIPcheck(struct sockaddr_in SockAddr);

fd_set	readfd;

unsigned char	ReqID[2];

int	status;
struct	pcap_pkthdr	*header;
struct	hostent	*host;

struct	sockaddr_in GWSockAddr;
struct	sockaddr_in LocalSyncSockAddr;
struct	sockaddr_in GlobalSyncSockAddr;

struct	ServerList	*LocalServerListPnt;	/* [JT[o[Xg̊Jn|C^[ */
struct	ServerList	*GlobalServerListPnt;	/* O[oT[o[Xg̊Jn|C^[ */

void	loadServerList (void)
{
	char	buff[128];
	FILE	*fd;
	char	token[] = { " \n\0"}; 
	struct	ServerList	*next;
	struct	ServerList	*before;
	struct hostent *hostent;

	LocalServerListPnt = NULL;
	GlobalServerListPnt = NULL;

	/* Q[g󂯎]̊ǗT[o[Xg */
	fd = fopen ("/etc/dscsd_g3/lserverlist","r");
	if (fd)
	{
		next = NULL;
		while (fgets (buff, 128, fd))
		{
			if (buff[0] != '#')	/* ꕶڂ̏ꍇ̓Rg */
			{
				hostent = gethostbyname (strtok(buff, token));
				if (hostent)
				{
					before = next;
					next = malloc (sizeof (struct ServerList));
					if (!next)
					{
						fprintf (LogFile, "Memory allocation error\n");
						exit (1);
					}	
					next->next_pnt = NULL;
					memcpy (&next->ip, hostent->h_addr_list[0], 4);
					if (before)
					{
						before->next_pnt = next;
					}
					else
					{
						LocalServerListPnt = next;
					}
				}
			}
		}
		fclose (fd);		 
	}
	else
	{
		fprintf (LogFile, "%s INFO  local server list not found. \n", loctime());
	}

	/* Q[g󂯎Ƒ̊ǗT[o[̏]̊ǗT[o[Xg */
	fd = fopen ("/etc/dscsd_g3/gserverlist","r");
	if (fd)
	{
		next = NULL;
		while (fgets (buff, 128, fd))
		{
			if (buff[0] != '#')
			{
				hostent = gethostbyname (strtok(buff, token));
				if (hostent)
				{
					before = next;
					next = malloc (sizeof (struct ServerList));
					if (!next)
					{
						fprintf (LogFile, "Memory allocation error\n");
						fflush (LogFile);
						fclose (LogFile);
						exit (1);
					}	
					next->next_pnt = NULL;
					memcpy (&next->ip, hostent->h_addr_list[0], 4);
					if (before)
					{
						before->next_pnt = next;
					}
					else
					{
						GlobalServerListPnt = next;
					}
				}
			}
		}
		fclose (fd);
	}		 
	else
	{
		fprintf (LogFile, "%s INFO  global server list not found. \n", loctime());
		fflush (LogFile);
	}

}

void	reloadServerList (void)
{
	struct	ServerList	*LocalServerSave;
	struct	ServerList	*GlobalServerSave;
	struct	ServerList	*next;


	LocalServerSave = LocalServerListPnt;
	GlobalServerSave = GlobalServerListPnt;
	loadServerList();

	while (LocalServerSave)
	{
		next = LocalServerSave->next_pnt;
		free (LocalServerSave);
		LocalServerSave = next;
	} 	

	while (GlobalServerSave)
	{
		next = GlobalServerSave->next_pnt;
		free (GlobalServerSave);
		GlobalServerSave = next;
	} 	
}

void	sendGlobalSyncPacket (char buff[])
{
	struct	sockaddr_in	SockAddr;
	struct	ServerList	*next;

	next = GlobalServerListPnt;
	while (next)
	{
		memset(&SockAddr, 0x00, sizeof(SockAddr));
		SockAddr.sin_port = htons(GlobalSyncPort);
		SockAddr.sin_family = AF_INET;
		SockAddr.sin_addr.s_addr = next->ip;
		sendto (GlobalSyncSocket, buff , 40, 0, (struct sockaddr *)&SockAddr , sizeof (struct sockaddr));
		next = next->next_pnt;
	}
}

void	sendLocalSyncPacket (char buff[])
{
	struct	sockaddr_in	SockAddr;
	struct	ServerList	*next;

	next = LocalServerListPnt;
	while (next)
	{
		memset(&SockAddr, 0x00, sizeof(SockAddr));
		SockAddr.sin_port = htons(LocalSyncPort);
		SockAddr.sin_family = AF_INET;
		SockAddr.sin_addr.s_addr = next->ip;
		sendto (LocalSyncSocket, buff , 40, 0, (struct sockaddr *)&SockAddr , sizeof (struct sockaddr));
		next = next->next_pnt;
	}
}

void	sendGlobalGWSyncPacket (char buff[])
{
	struct	sockaddr_in	SockAddr;
	struct	ServerList	*next;

	next = GlobalServerListPnt;
	while (next)
	{
		memset(&SockAddr, 0x00, sizeof(SockAddr));
		SockAddr.sin_port = htons(GlobalSyncPort);
		SockAddr.sin_family = AF_INET;
		SockAddr.sin_addr.s_addr = next->ip;
		sendto (GlobalSyncSocket, buff , 24, 0, (struct sockaddr *)&SockAddr , sizeof (struct sockaddr));
		next = next->next_pnt;
	}
}

void	sendLocalGWSyncPacket (char buff[])
{
	struct	sockaddr_in	SockAddr;
	struct	ServerList	*next;

	next = LocalServerListPnt;
	while (next)
	{
		memset(&SockAddr, 0x00, sizeof(SockAddr));
		SockAddr.sin_port = htons(LocalSyncPort);
		SockAddr.sin_family = AF_INET;
		SockAddr.sin_addr.s_addr = next->ip;
		sendto (LocalSyncSocket, buff , 24, 0, (struct sockaddr *)&SockAddr , sizeof (struct sockaddr));
		next = next->next_pnt;
	}
}

/*
	sANZXh~ׁ̈Ao^T[o[ȊȌ͔j
*/
int	LocalSenderIPcheck(struct sockaddr_in SockAddr)
{
	struct	ServerList	*next;

	next = LocalServerListPnt;

	while (next)
	{
		if (!memcmp( &next->ip, &SockAddr.sin_addr, 4)) return true;
 		next = next->next_pnt;
	}
	return false;
}

/*
	sANZXh~ׁ̈Ao^T[o[ȊȌ͔j
*/
int	GlobalSenderIPcheck(struct sockaddr_in SockAddr)
{
	struct	ServerList	*next;

	next = GlobalServerListPnt;

	while (next)
	{
		if (!memcmp( &next->ip, &SockAddr.sin_addr, 4)) return true;
 		next = next->next_pnt;
	}
	return false;
}

/*
	̊ǗT[o[́ue[uvvǗe[uɔf
	ē]sB́AȂB
*/
void	GlobalUpdateTableSync (void)
{
	int	length;
	int	Fromlen;
;	char	buff[64];
	struct	sockaddr_in recvSockAddr;

	struct	TrustTable	*next;

	Fromlen = sizeof (struct sockaddr);
	length = recvfrom (GlobalSyncSocket, buff, 64 , 0,  (struct sockaddr *)&recvSockAddr, &Fromlen);

	if (!memcmp (buff, ReqID, 2)) 	/* ox00, 0x03 */
	{
		if (!GlobalSenderIPcheck(recvSockAddr)) return;	/* M̂hoAXT[o[XgɂȂꍇ͔j */
		if (length == 40)
		{
			if (SyncUpdateTable(buff))
				sendLocalSyncPacket(buff);	/* [J̑̊ǗT[o[Ɂue[uvv] */
     	 	}
		else if (length == 24)
		{
			if (updateGWaddrFromTrust(buff))
				sendLocalGWSyncPacket(buff);	/* [J̑̊ǗT[o[Ɂue[uvv] */
		}
	}
}

int	Call_Check(char callsign[], char zone_callsign[], char area_callsign[], unsigned char ipaddress[])
{
	pthread_t	thread_id;
	struct	msg_info	*v_info;
	uint16_t	rand_temp;
	char	CallErrorType;

	if (memcmp (callsign, area_callsign, 7))
	{
		CallErrorType = callcheck(callsign);
		if (CallErrorType)
		{
			if (Info) fprintf (LogFile, "%s ERROR Invalid Call Sign %8.8s %8.8s %8.8s %d.%d.%d.%d\n",
				loctime(), callsign, area_callsign, zone_callsign,
				ipaddress[0], ipaddress[1], ipaddress[2], ipaddress[3]);
			fflush (LogFile);
			if (AudioMsg)
			{
				v_info = malloc (sizeof (struct msg_info));
				memcpy (v_info->ip, ipaddress, 4);
				memcpy (v_info->callsign, "CQCQCQ  ", 8);
				memcpy (v_info->zone, zone_callsign, 8);
				memcpy (v_info->area, area_callsign, 8);
				switch (CallErrorType)
				{
					case 0x01:	/* R[TC */
						memcpy (v_info->FileName, "/etc/dscsd_g3/audio/wrong_call01.dsv\0", 37);
						memcpy (v_info->SlowMsg, "MY CALL NOT DEFINE  ", 20);
						break;
					case 0x02:	/* ŏ */
						memcpy (v_info->FileName, "/etc/dscsd_g3/audio/wrong_call02.dsv\0", 37);
						memcpy (v_info->SlowMsg, "FIRST SPACE  ", 12);
						memcpy (&v_info->SlowMsg[12], callsign, 8);
						break;
					case 0x03	/* pȊO܂܂Ă */:
						memcpy (v_info->FileName, "/etc/dscsd_g3/audio/wrong_call03.dsv\0", 37);
						memcpy (v_info->SlowMsg, "INVALID CHR  ", 12);
						memcpy (&v_info->SlowMsg[12], callsign, 8);
						break;
					case 0x04:	/* @햼󔒂͉płȂ */
						memcpy (v_info->FileName, "/etc/dscsd_g3/audio/wrong_call04.dsv\0", 37);
						memcpy (v_info->SlowMsg, "WRONG MOD.  ", 12);
						memcpy (&v_info->SlowMsg[12], callsign, 8);
						break;
					case 0x05:	/* ĂR[TC */
						memcpy (v_info->FileName, "/etc/dscsd_g3/audio/wrong_call05.dsv\0", 37);
						memcpy (v_info->SlowMsg, "WRONG CALL  ", 12);
						memcpy (&v_info->SlowMsg[12], callsign, 8);
						break;
					default:
						memcpy (v_info->FileName, "/etc/dscsd_g3/audio/wrong_call05.dsv\0", 37);
						memcpy (v_info->SlowMsg, "WRONG CALL  ", 12);
						memcpy (&v_info->SlowMsg[12], callsign, 8);
						break;
				}
				memcpy (v_info->sender, AudioSenderCallsign, 8);
				memcpy (v_info->sender2, "JARL", 4);
				status = pthread_create(&thread_id, NULL, AudioMessage,  v_info);
			}
			return false;
		}
	}
	return true;
}

/*
	̊ǗT[o[́ue[uvvǗe[uɔf
	́AȂB
*/
void	LocalUpdateTableSync (void)
{
	int	length;
	int	cmp;
	int	Fromlen;
;	unsigned char	buff[64];
	struct	sockaddr_in recvSockAddr;

	Fromlen = sizeof (struct sockaddr);
	length = recvfrom (LocalSyncSocket, buff, 64 , 0,  (struct sockaddr *)&recvSockAddr, &Fromlen);
//	length = recv (LocalSyncSocket, buff, 128 , 0);

	if (!memcmp (buff, ReqID, 2))	/* 0x00, 0x03 */
	{
		if (!LocalSenderIPcheck(recvSockAddr)) return;	/* M̂hoAhXT[o[XgɂȂꍇ͔j */
		if (length == 40) 
		{
//printf ("debug %d.%d.%d.%d\n", buff[12],buff[13],buff[14],buff[15]); 
//			if (AutoEntry && (buff[32] == 0x01) && (buff[43] != 'S'))		/* This version only */
//			{
//				SendUpdateAck(buff);
//			}
			if (!Call_Check(&buff[8], &buff[16], &buff[24], &buff[36])) return;		/* ǃR[TC̐ݒ肪ԈĂ */
			if (SyncUpdateTable(buff))
				sendGlobalSyncPacket(buff);	/* O[ȏ̊ǗT[o[Ɂue[uvv] */
     		}
		else if (length == 24)
		{
			if (updateGWaddrFromTrust(buff))
				sendGlobalGWSyncPacket(buff);	/* O[ȏ̊ǗT[o[Ɂue[uEEvv] */
		}
	}
}

/*
	e[ȕ
*/
int	SyncUpdateTable(char buff[])
{
	struct	msg_info		*v_info;
	struct	TrustTable	*next;
	int	cmp;
	u_int16_t	proto;
	pthread_t	thread_id;

	if (AutoEntry && AutoEntryListCheck(&buff[8])) return true;

	next = start_pnt(&buff[8]);	/* Jnʒu𓾂 */
	while (next)
	{
		cmp = memcmp (next->callsign, &buff[8],  8);
		if (!cmp)
		{
			if (buff[15] == 'S')
			{
				if (memcmp(&next->IPaddr, &buff[36] ,4)) Replace_GW_IP(&buff[8], &buff[36]);
				return true;
			}
			memcpy ((char *)next->zone_callsign, &buff[16], 8);
			memcpy (next->area_callsign, &buff[24], 8);
			memcpy (next->IPaddr, &buff[36], 4);
			time (&(next->update_time));
			proto = (buff[2] << 8) | buff[3];
			if (proto == 0) proto = 1;
			next->protocol |= proto;
			if (buff[15] != 'S')
			{
				if (Info)
				{
					fprintf (LogFile, "%s INFO  update %8.8s %8.8s %8.8s %-d.%-d.%-d.%-d\n",
					loctime(), next->callsign,next->area_callsign,next->zone_callsign,
					buff[36]&0xff, buff[37]&0xff, buff[38]&0xff, buff[39]&0xff);
					fflush (LogFile);
				}
			}
			break;	
		}
		else if (cmp > 0)
		{
			next = NULL;
			break;
		}
		next = next->next_pnt;
	}
	if (!next)
	{
		if (buff[15] == 'S') return true;
		if (Debug) fprintf (LogFile, "%s DEBUG not found %8.8s in Table (%8.8s %8.8s)\n", loctime(), &buff[8], &buff[16], &buff[24]);
		if (AutoEntry)
		{
			if (AutoEntryCallCheck(&buff[8]))
			{
				proto = (buff[2] << 8) | buff[3];
				if (proto == 0) proto = 1;
				insertTrustTable (&buff[8],  &buff[16], &buff[24], proto, AUTOENTRY, &buff[36], "\0\0\0\0");
				return true;
			}
			v_info = malloc (sizeof (struct msg_info));
			if (memcmp(&buff[8], "7M3TJZ T", 8))	/* debug */
			{				/* debug */
				buff[36] = 0x9d;		/* debug */
				buff[37] = 0x07;		/* debug */
				buff[38] = 0x8b;		/* debug */
				buff[39] = 0x59;		/* debug */
			}				/* debug */
			memcpy (v_info->ip, &buff[36], 4);
			memcpy (v_info->callsign, &buff[8], 8);
			memcpy (v_info->zone, &buff[16], 8);
			memcpy (v_info->area, &buff[24], 8);
			memcpy (v_info->FileName, "/etc/dscsd_g3/audio/autoentry01.dsv\0", 36);
			memcpy (v_info->SlowMsg, "AUTO. ENTRY REQUEST ", 20);
			memcpy (v_info->sender, AutoEntrySenderCallsign, 8);
			memcpy (v_info->sender2, "AUTO", 4);
			createAutoEntryInfoList(v_info);
			status = pthread_create(&thread_id, NULL, AudioMessage,  v_info);
		}
		return false;
	}
	return true;
}

/*
	[JIP̏
*/
int	update_local_ip(char string[] )
{
	struct	TrustTable	*next;
	int	cmp;
	char	buff[64];
	char	*token = {"\t\n"}; 
	char	*ip;
	char	*call;
	FILE	*in;

	in = fopen (string, "r");
	if (!in) return false;

	while (fgets (buff, 63, in))
	{
		call = strtok(buff, token);
		ip = strtok(NULL, token);
		next = start_pnt(call);	/* Jnʒu𓾂 */
		while (next)
		{
			cmp = memcmp (next->callsign, call, 8);
			if (!cmp)
			{
				inet_string2binary(next->LocalIPaddr, ip);
				if (*(call+7) != 'S')
				{
					if (Info)
					{
						fprintf (LogFile, "%s INFO  update local IP %8.8s %8.8s %8.8s %-d.%-d.%-d.%-d\n",
						loctime(), next->callsign,next->area_callsign,next->zone_callsign,
						next->LocalIPaddr[0], next->LocalIPaddr[1], next->LocalIPaddr[2], next->LocalIPaddr[3]);
						fflush (LogFile);
					}
				}
				break;	
			}
			else if (cmp > 0)
			{
				break;
			}
			next = next->next_pnt;
		}
	}
	fclose (in);
}

void	SendUpdateAck(char buff[])
{
	char	send_buff[36];

	struct	sockaddr_in	SockAddr;

	memset(&SockAddr, 0x00, sizeof(SockAddr));
	memcpy (&SockAddr.sin_port, &buff[32], 2);
	SockAddr.sin_family = AF_INET;
	memcpy (&SockAddr.sin_addr.s_addr, &buff[36], 4);
	memcpy (send_buff, buff, 32);
	send_buff[2] = 0x80;
	send_buff[3] = 0x00;	
	memcpy (&send_buff[32], &buff[36], 4);
	sendto (GWSocket, send_buff , 36, 0, (struct sockaddr *)&SockAddr , sizeof (struct sockaddr));
}