/*
	U^ǗT[o[p@wb_[t@C
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <assert.h>
#include <signal.h>
#include <sys/time.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <resolv.h>
#include <errno.h>
#include <pthread.h>

struct msg_info {
	unsigned char	ip[4];
	char	callsign[8];
	char	zone[8];
	char	area[8];
	char	sender[8];
	char	sender2[4];
	char	FileName[64];
	char	SlowMsg[20];
};

struct echo_info {
	struct	echo_info	*next_pnt;
	unsigned char	ip[4];
	char	callsign[8];
	char	zone[8];
	char	area[8];
	char	FileName[32];
	time_t	update_time;
	FILE	*EchoFile;
	long int	cnt;
	unsigned char	msgID[2];
};

struct autoentry_info {
	struct	autoentry_info	*next_pnt;
	unsigned char	ip[4];
	char	callsign[8];
	char	zone[8];
	char	area[8];
	char	FileName[64];
	time_t	update_time;
	FILE	*EchoFile;
	long int	cnt;
	int	state;
	unsigned char	msgID[2];
};


struct	busy_stack {
	struct	busy_stack	*next_pnt;
	unsigned char	ip[4];
	unsigned char	msgID[2];
	unsigned	char	check;
	time_t	recv_time;
};

struct	TrustTable
{
	struct	TrustTable	*next_pnt;
	char	callsign[8];
	char	area_callsign[8];
	char	zone_callsign[8];
	char	reserve[4];
	unsigned char	IPaddr[4];
	unsigned char	LocalIPaddr[4];
	time_t	update_time;
	u_int16_t	protocol;
	union
	{
		struct
		{
			unsigned char	localEntry		: 1;
			unsigned char	dxEntry		: 1;
			unsigned char	autoEntry		: 1;
			unsigned char	accEntry		: 1;
			unsigned char			: 3;
			unsigned char	del		: 1;
		} flags;
		unsigned	char	flag;
	};
};

void	exit();
char	*ltime(time_t t);
char	*utctime(void);
char	*loctime(void);
void	tableprint(void);
void	insert_data(void);
void	UpdateTable (char buf[], struct sockaddr_in recvSockAddr);
void	LocalUpdateTableSync(void);
void	GlobalUpdateTableSync(void);
void	SyncUpdateSend(void);
void	loadDBfile(void);
void	insertDBfile (void);
int	updateDBfile(char FileName[], unsigned char insertType);
void	Replace_GW_IP(char callsign[], unsigned char IPaddress[]);
void	read_inet(int time_interval);
void	pipe_read(void);
void	inet_string2binary (unsigned char  *ipaddr, unsigned char ip[]);
int	insertTrustTable (char callsign[], char area_callsign[], char zone_callsign[], u_int16_t protocol, unsigned char insertType, unsigned char ipaddress[], unsigned char localipaddress[]);
void	GW_Process(void);
void	read_config(int argc, char **argv);
void	ackUpdateTable(char buff[]);
void	nakUpdateTable(char buff[]);
int	reqFindGWfromCallSign(char buff[], struct sockaddr_in recvSockAddr);
void	reqFindGWfromRepeater(char buff[], struct sockaddr_in recvSockAddr);
void	reqFindGWfromLocalIP(char buff[], struct  sockaddr_in recvSockAddr);
void	sendSyncPacket(char buff[]);
void	sendReply (char buff[]);
char	callcheck(char callsign[]);
int	Call_Check(char callsign[], char zone_callsign[], char area_callsign[], unsigned char ipaddress[]);
void	loadCallCheckACL(void);
void	loadServerList(void);
void	exit_set(int signal);
void	log_reopen(int signal);
void	ReSet(void);
int	SyncUpdateTable(char buff[]);
struct	TrustTable *start_pnt(char callsign[]);
int	LocalSenderIPcheck(struct sockaddr_in SockAddr);
int	GlobalSenderIPcheck(struct sockaddr_in SockAddr);
time_t	unix_time(char time_string[]);
void	make_index(void);
int	update_local_ip(char string[]);
int	updateGWaddress (char buff[], struct sockaddr_in recvSockAddr);
int	updateGWaddrFromTrust(char buff[]);
uint16_t	calc_crc (unsigned char string[], int length);
void	StartRepeater(void);
void	read_voice_packet(void);
char	AudioMsgCallCheck(struct msg_info *voice);
void	*AudioMessage (void *arg);
void	SendAudioMsg (struct msg_info *voice);
void	loadMsgCallCheckACL(void);
void	ReloadMsgCallCheckACL(void);
void	EchoServerHeader (unsigned char header[], unsigned char ip[]);
void	EchoServerVoice (unsigned char voice[], unsigned char ip[]);
void	UpdateMsgServerIP(unsigned char sender[], unsigned char ZrCall[], unsigned char ArCall[]);
void	UpdateEchoServerIP(void);
void	*SendEchoMsg(void *arg);
unsigned char	CallVoice (unsigned char callsign[], unsigned char seq, FILE *EchoFile);
void	BusyStack(unsigned char ip[4], unsigned char msgID[]);
int	BusyCheck(unsigned char ip[4]);
void	BusyDelete(void);
int	delete_table(void);
void	reqFindLastAccess(char buff[], struct sockaddr_in SockAddr);
void	checkEchoInfo(void);
void	checkAutoEntryInfo(void);
char	AutoEntryCallCheck(char callsign[]);
void	AutoEntryDelete(void);
int	AutoEntryListCheck(char callsign[]);
void	SendUpdateAck(char buff[]);
void	statics(void);

#define	true	1;
#define	false	0;

#define	PORT_GW	30001		/* */
#define	PORT_LocalSYNC	30002		/* */
#define	PORT_GlobalSYNC	30003		/* */
#define	PORT_VOICE	40000		/* */

#define	CSDBFILE_PATH	"/var/dscsd/masterdb.txt"

#define	DEL		0x80
#define	ACCESSPOINT	0x08
#define	AUTOENTRY	0x04
#define	DXENTRY	0x02
#define	LOCALENTRY	0x01

#define	MAXBUSYTIMEOUT	300		/* seconds */

FILE	*LogFile;

/* tO̐ݒ */

char	AutoEntry;
char	Debug;
char	Info;
char	CallCheck;
char	AudioMsg;
char	EchoSrv;
char	ReStartSW;

int	GWPort;
int	LocalSyncPort;
int	GlobalSyncPort;
int	VoicePort;
int	cmdmode;

int	cmdin;

uint16_t	rand_save;
char	csdbfile_path[128];

struct	sockaddr_in GWSockAddr;
struct	sockaddr_in LocalSyncSockAddr;
struct	sockaddr_in GlobalSyncSockAddr;
struct	sockaddr_in RecvVoiceSockAddr;

int	GWSocket;
int	LocalSyncSocket;
int	GlobalSyncSocket;
int	RecvVoiceSocket;

char	EchoSenderCallsign[8];
char	AudioSenderCallsign[8];
char	AutoEntrySenderCallsign[8];
char	TrustZrCallsign[8];
char	TrustArCallsign[8];
char	TrustIpAddress[16];

struct	table_update
{
	char	UpdateID[2];
	char	flag[2];
	char	reserve[4];
	char	callsign[8];
	char	zone_callsign[8];
	char	zrea_callsign[8];
};

struct	table_update_sync
{
	char	UpdateID[2];
	char	flag[2];
	char	reserve[4];
	char	callsign[8];
	char	zone_callsign[8];
	char	area_callsign[8];
	char	reserve2[4];
	char	ipaddress[4];
};

fd_set	readfd;
char	pkt[256];
char	temp[64];

struct	CallCheckACL
{
	struct	CallCheckACL *next_pnt;
	char	callsign[8];
	char	acl;
};

struct	ServerList
{
	struct	ServerList	*next_pnt;
	u_int32_t	ip;
	int	port;
};

struct	IndexTable
{
	struct	IndexTable	*next_pnt;
	struct	TrustTable	*pointer;
};
		