﻿using NUnit.Framework;
using Sasa.QualityTools.DrFx.Core.Translation;
using Sasa.QualityTools.DrFx.Core.Tests.Unit.TestingUtilities;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace Sasa.QualityTools.DrFx.Core.Tests.Unit.Translation
{
    [TestFixture]
    public class DrFxRuleLoaderTest
    {
        [Test]
        public void TestLoadDrFxRulesFromStream()
        {
            const string contents =
                @"<?xml version=""1.0"" encoding=""utf-8"" ?>" +
                @"<Rules>" +
                @"  <Rule CheckId=""CA0000"" Category=""Category1"">" +
                @"    <Name>Name1</Name>" +
                @"    <Resolution>" +
                @"      <Content>Content1</Content>" +
                @"      <Pattern>Pattern1</Pattern>" +
                @"    </Resolution>" +
                @"    <Resolution>" +
                @"      <Content>Content2</Content>" +
                @"      <Pattern>Pattern2</Pattern>" +
                @"    </Resolution>" +
                @"  </Rule>" +
                @"</Rules>";

            Stream stream = StreamGenerator.GenerateWith(contents);
            List<DrFxRule> rules = new List<DrFxRule>(DrFxRuleLoader.Load(stream));

            Assert.AreEqual(1, rules.Count);
            DrFxRule rule = rules[0];
            Assert.AreEqual("CA0000", rule.CheckId);
            Assert.AreEqual("Category1", rule.Category);
            Assert.AreEqual("Name1", rule.Name);

            List<Resolution> resolutions = new List<Resolution>(rule.Resolutions);
            Assert.AreEqual(2, resolutions.Count);
            Assert.AreEqual("Content1", rule.Resolutions[0].Content);
            Assert.AreEqual("Pattern1", rule.Resolutions[0].Pattern);
            Assert.AreEqual("Content2", rule.Resolutions[1].Content);
            Assert.AreEqual("Pattern2", rule.Resolutions[1].Pattern);
        }
    }
}
