﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using Sasa.QualityTools.DrFx.Core;
using Sasa.QualityTools.DrFx.Explorer.Rule;
using System;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.IO;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Navigation;

namespace Sasa.QualityTools.DrFx.Explorer
{
    public partial class FxCopRuleWindow : Window
    {
        public Collection<FxCopRule> Rules { get; private set; }



        public FxCopRuleWindow()
        {
            InitializeComponent();
        }



        protected override void OnContentRendered(EventArgs e)
        {
            base.OnContentRendered(e);

            FxCopProcessConfiguration configuration = new FxCopProcessConfiguration();
            string rulesDir = Path.Combine(configuration.FxCopInstallDirectory, "Rules");

            FxCopRuleLoader loader = new FxCopRuleLoader();
            foreach (string path in Directory.GetFiles(rulesDir))
            {
                loader.AssemblyPaths.Add(path);
            }
            Rules = loader.Load();
            loader.Translate(Rules);

            this.frame.Navigate(new Uri("/FxCopRuleListPage.xaml", UriKind.Relative));
        }

        private void OnNavigateCompleted(object sender, NavigationEventArgs e)
        {
            Page page = (Page)e.Content;
            page.DataContext = Rules;
            ICollectionView collectionView = CollectionViewSource.GetDefaultView(page.DataContext);
            collectionView.GroupDescriptions.Add(new PropertyGroupDescription("Category"));
        }
    }
}
