﻿using System;
using System.Diagnostics.CodeAnalysis;
using System.Runtime.InteropServices;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Interoperability
{
    public static class Rule1404
    {
        // このメソッドは CA1404 に違反しています。
        [SuppressMessage("Microsoft.Security", "CA2122:DoNotIndirectlyExposeMethodsWithLinkDemands")]
        public static void DoSomething()
        {
            bool success = RemoveDirectory("foo");
            Console.WriteLine(success);
            Console.WriteLine(Marshal.GetLastWin32Error());
        }
    
        [SuppressMessage("Microsoft.Design", "CA1060:MovePInvokesToNativeMethodsClass")]
        [DllImport("kernel32.dll", CharSet = CharSet.Unicode)]
        [return: MarshalAs(UnmanagedType.Bool)]
        private static extern bool RemoveDirectory(string name);
    }
}
