﻿using System;
using System.Runtime.Serialization;
using System.Security.Permissions;
using System.Diagnostics.CodeAnalysis;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Usage
{
    // このクラスは CA2240:Default に違反しています。
    [Serializable]
    public class Rule2240A : Rule2240C
    {
        private string name = "Rule2240A";

        public Rule2240A()
        {
        }

        protected Rule2240A(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }

        public override string ToString()
        {
            return this.name;
        }
    }

    // このクラスは CA2240:MakeVisible に違反しています。
    [Serializable]
    public class Rule2240B : ISerializable
    {
        private string name = "Rule2240B";

        public Rule2240B()
        {
        }

        protected Rule2240B(SerializationInfo info, StreamingContext context)
        {
        }

        [SecurityPermission(SecurityAction.Demand, SerializationFormatter = true)]
        internal virtual void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            this.name = info.ToString() + context.ToString();
        }

        [SuppressMessage("Microsoft.Design", "CA1033:InterfaceMethodsShouldBeCallableByChildTypes")]
        [SecurityPermission(SecurityAction.LinkDemand, Flags = SecurityPermissionFlag.SerializationFormatter)]
        void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
        {
            GetObjectData(info, context);
        }

        public override string ToString()
        {
            return this.name;
        }
    }


    // このクラスは CA2240:MakeOverridable に違反しています。
    [Serializable]
    public class Rule2240C : ISerializable
    {
        private string name = "Rule2240C";

        public Rule2240C()
        {
        }

        protected Rule2240C(SerializationInfo info, StreamingContext context)
        {
        }

        [SecurityPermission(SecurityAction.LinkDemand, Flags = SecurityPermissionFlag.SerializationFormatter)]
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
        }

        public override string ToString()
        {
            return this.name;
        }
    }
}
