﻿using System;
using System.Diagnostics.CodeAnalysis;

namespace Sasa.QualityTools.DrFx.Tests.Violation.CSharp.Microsoft.Naming
{
    // このクラスは CA1711:TypeNoAlternate に違反しています。
    public class Rule1711Collection
    {
        public string Value { get; private set; }

        // このメソッドは CA1711:MemberWithAlternate に違反しています。
        [SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly")]
        public void SetValueImpl(string value)
        {
            Value = value;
        }
    }

    // このクラスは CA1711:TypeNewerVersion に違反しています。
    public class Rule1711Ex
    {
        public string Value { get; private set; }

        // このメソッドは CA1711:MemberNewerVersion に違反しています。
        public void SetValueEx(string value)
        {
            Value = value;
        }
    }
}
