﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;
using System.Collections.ObjectModel;

namespace Sasa.QualityTools.DrFx.Explorer.Report
{
    /// <summary>
    /// FxCop ルールに違反した型の情報を表すクラスです。
    /// </summary>
    public class TypeWarning
    {
        /// <summary>
        /// FxCop ルールに違反したメンバーの情報のコレクション。
        /// </summary>
        private Collection<MemberWarning> members = new Collection<MemberWarning>();

        /// <summary>
        /// アセンブリに対する違反メッセージのコレクション。
        /// </summary>
        private Collection<FxCopIssue> issues = new Collection<FxCopIssue>();



        /// <summary>
        /// 型名。
        /// </summary>
        public string Name { get; internal set; }

        /// <summary>
        /// 型の種類。
        /// </summary>
        public string Kind { get; internal set; }

        /// <summary>
        /// FxCop ルールに違反したメンバーの情報のコレクション。
        /// </summary>
        public Collection<MemberWarning> Members
        {
            get
            {
                return this.members;
            }
        }

        /// <summary>
        /// アセンブリに対する違反メッセージのコレクション。
        /// </summary>
        public Collection<FxCopIssue> Issues
        {
            get
            {
                return this.issues;
            }
        }
    }
}
