﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using NUnit.Framework;
using Sasa.QualityTools.DrFx.Console;
using System;

namespace Sasa.QualityTools.DrFx.Console.Tests.Unit
{
    [TestFixture]
    public class OptionTest
    {
        /// <summary>
        /// 等値比較メソッドが期待通り動作することをテストします。
        /// </summary>
        /// <param name="symbol1">オプションのシンボル。</param>
        /// <param name="hasArg1">オプションが引数をとるかどうか。</param>
        /// <param name="symbol2">オプションのシンボル。</param>
        /// <param name="hasArg2">オプションが引数をとるかどうか。</param>
        /// <returns>比較結果。</returns>
        [TestCase('a', true, 'a', true, Result = true,
            Description = "シンボル、引数の有無が同一ならば Eqauls が true となることをテストします。")]
        [TestCase('a', true, 'a', false, Result = false,
            Description = "引数有無の値が異なれば Equals が false となることをテストします。")]
        [TestCase('a', true, 'b', true, Result = false,
            Description = "シンボルの値が異なれば Equals が false となることをテストします。")]
        public bool TestEqualityWithEquals(char symbol1, bool hasArg1, char symbol2, bool hasArg2)
        {
            Option option1 = new Option(symbol1, hasArg1);
            Option option2 = new Option(symbol2, hasArg2);
            return option1.Equals(option2);
        }

        /// <summary>
        /// 等値演算子が期待通り動作することをテストします。
        /// </summary>
        /// <param name="symbol1">オプションのシンボル。</param>
        /// <param name="hasArg1">オプションが引数をとるかどうか。</param>
        /// <param name="symbol2">オプションのシンボル。</param>
        /// <param name="hasArg2">オプションが引数をとるかどうか。</param>
        /// <returns>比較結果。</returns>
        [TestCase('a', true, 'a', true, Result = true,
            Description = "シンボル、引数の有無が同一ならば == が true となることをテストします。")]
        [TestCase('a', true, 'a', false, Result = false,
            Description = "引数有無の値が異なれば == が false となることをテストします。")]
        [TestCase('a', true, 'b', true, Result = false,
            Description = "シンボルの値が異なれば == が false となることをテストします。")]
        public bool TestEqualityWithOperatorEq(char symbol1, bool hasArg1, char symbol2, bool hasArg2)
        {
            Option option1 = new Option(symbol1, hasArg1);
            Option option2 = new Option(symbol2, hasArg2);
            return option1 == option2;
        }

        /// <summary>
        /// 非等値演算子が期待通り動作することをテストします。
        /// </summary>
        /// <param name="symbol1">オプションのシンボル。</param>
        /// <param name="hasArg1">オプションが引数をとるかどうか。</param>
        /// <param name="symbol2">オプションのシンボル。</param>
        /// <param name="hasArg2">オプションが引数をとるかどうか。</param>
        /// <returns>比較結果。</returns>
        [TestCase('a', true, 'a', true, Result = false,
            Description = "シンボル、引数の有無が同一ならば != が false となることをテストします。")]
        [TestCase('a', true, 'a', false, Result = true,
            Description = "引数有無の値が異なれば != が true となることをテストします。")]
        [TestCase('a', true, 'b', true, Result = true,
            Description = "シンボルの値が異なれば != が true となることをテストします。")]
        public bool TestEqualityWithOperatorNe(char symbol1, bool hasArg1, char symbol2, bool hasArg2)
        {
            Option option1 = new Option(symbol1, hasArg1);
            Option option2 = new Option(symbol2, hasArg2);
            return option1 != option2;
        }
    }
}
