﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;

namespace Sasa.QualityTools.DrFx.Core
{
    internal static class MessageProvider
    {
        /// <summary>
        /// Creates the message that expresses analysis target files was not specified.
        /// </summary>
        /// <returns>The created message.</returns>
        internal static string TargetFileWasNotSpecified()
        {
            return "分析対象アセンブリを少なくとも 1 つは指定してください。";
        }

        /// <summary>
        /// Creates the message that expresses an analysis target file was not found.
        /// </summary>
        /// <param name="file">The invalid analysis target file.</param>
        /// <returns>The created message.</returns>
        internal static string TargetFileWasNotFound(string file)
        {
            return "分析対象アセンブリのパスを修正してください。'" + file + "' が見つかりません。";
        }

        /// <summary>
        /// Creates the message that expresses an output file indicates a directory.
        /// </summary>
        /// <param name="file">The invalid output file.</param>
        /// <returns>The created message.</returns>
        internal static string OutputFileWasDirectory(string file)
        {
            return "レポート出力先パスを修正してください。'" + file + "' はディレクトリです。";
        }

        /// <summary>
        /// Creates the message that expresses an output directory was not found.
        /// </summary>
        /// <param name="directory">The invalid output directory.</param>
        /// <returns>The created message.</returns>
        internal static string OutputDirectoryWasNotFound(string directory)
        {
            return "レポート出力先パスを修正してください。'" + directory + "' というディレクトリが見つかりません。";
        }

        /// <summary>
        /// Creates the message that expresses an analysis rule file was not found.
        /// </summary>
        /// <param name="file">The invalid analysis rule file.</param>
        /// <returns>The created message.</returns>
        internal static string RuleFileWasNotFound(string file)
        {
            return "ルールアセンブリのパスを修正してください。'" + file + "' が見つかりません。";
        }

        /// <summary>
        /// Creates the message that expresses a directory to search depenced assemblies was not found.
        /// </summary>
        /// <param name="directory">The invalid dependency directory.</param>
        /// <returns>The created message.</returns>
        internal static string DependencyDirectoryWasNotFound(string directory)
        {
            return "依存先アセンブリ検索ディレクトリを修正してください。'" + directory + "' が見つかりません。";
        }

        /// <summary>
        /// Creates the message that expresses the FXCop install directory was not found.
        /// </summary>
        /// <param name="directory">The invalid FXCop install directory.</param>
        /// <returns>The created message.</returns>
        internal static string FxCopIntallDirectoryWasNotFound(string directory)
        {
            return "FxCop インストールディレクトリの値を修正してください。'" + directory + "' というディレクトリが存在しないか、このパスはディレクトリ以外を指しています。";
        }

        /// <summary>
        /// Creates the message that expresses the FXCopCmd.exe was not found.
        /// </summary>
        /// <param name="file">The invalid path of FxCopCmd.exe.</param>
        /// <returns>The created message.</returns>
        internal static string FxCopCmdWasNotFound(string file)
        {
            return "FxCop インストールディレクトリの値を修正してください。'" + file + "' が見つかりません。";
        }

        /// <summary>
        /// Creates the message that expresses the FXCop Rules directory was not found.
        /// </summary>
        /// <param name="directory">The invalid Rules directory.</param>
        /// <returns>The created message.</returns>
        internal static string FxCopRuleDirectoryWasNotFound(string directory)
        {
            return "FxCop インストールディレクトリの値を修正してください。'" + directory + "' が見つかりません。";
        }

        internal static string DictionaryFileWasNotFound(string file)
        {
            return "カスタムディクショナリファイルのパスを修正してください。'" + file + "' というファイルが見つかりません。";
        }
    }
}
