﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using NUnit.Framework;
using Sasa.QualityTools.DrFx.Console;
using System;
using System.Collections.Generic;

namespace Sasa.QualityTools.DrFx.Console.Tests.Unit
{
    [TestFixture]
    public class LongOptionCollectionTest
    {
        /// <summary>
        /// シンボル指定によるオプション定義の取得が期待通り動作することをテストします。
        /// </summary>
        /// <param name="longOption">ロングオプションを表す文字列。</param>
        /// <returns>オプション定義の文字列表現。</returns>
        [TestCase("--alpha", Result = "a|False",
            Description = "指定したロングオプションに対応するオプション定義が取得できることをテストします。")]
        [TestCase("--beta", Result = "b|True",
            Description = "指定したロングオプションに対応するオプション定義が取得できることをテストします。")]
        public string TestGetOption(string longOption)
        {
            LongOptionCollection options = new LongOptionCollection();
            options.Add("alpha", 'a', false);
            options.Add("beta", 'b', true);
            Option option = options.GetOption(longOption);
            return option.Symbol + "|" + option.HasArgument;
        }

        /// <summary>
        /// 登録されていないシンボルでオプション定義を取得しようとした場合は、オプション未定義例外が発生することをテストします。
        /// </summary>
        public void TestGetUndefinedOption()
        {
            LongOptionCollection options = new LongOptionCollection();
            options.Add("alpha", 'a', false);
            options.Add("beta", 'b', true);
            try
            {
                Option option = options.GetOption("--charlie");
            }
            catch (UndefinedOptionException e)
            {
                Assert.AreEqual("--charlie", e.SpecifiedOption);
            }
        }
    }
}
