﻿/*
 * DrFx - FxCop Report Translator and Visualizer.
 * Copyright (C) 2010 Sasa Yuan
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



using System;
using System.Collections;
using System.Collections.Generic;

namespace Sasa.QualityTools.DrFx.Console
{
    /// <summary>
    /// オプション定義のコレクションを表します。
    /// </summary>
    internal class OptionCollection : IEnumerable<Option>
    {
        /// <summary>
        /// オプション定義のリスト。
        /// </summary>
        private List<Option> options;



        /// <summary>
        /// 新しいインスタンスを初期化します。
        /// </summary>
        internal OptionCollection()
        {
            this.options = new List<Option>();
        }



        /// <summary>
        /// コレクションに新しいオプション定義を追加します。
        /// </summary>
        /// <param name="symbol">オプションを表すシンボル。</param>
        /// <param name="hasArgument">オプションが引数を持つかどうか。</param>
        /// <returns>オプション定義追加後のオプションコレクション。</returns>
        internal OptionCollection Add(char symbol, bool hasArgument)
        {
            Option option = new Option(symbol, hasArgument);
            this.options.Add(option);
            return this;
        }

        /// <summary>
        /// 指定されたシンボルに対応するオプション定義を取得します。
        /// </summary>
        /// <param name="symbol">オプションを表すシンボル。</param>
        /// <returns>指定されたシンボルに対応するオプション定義。</returns>
        internal Option GetOption(char symbol)
        {
            Option option = this.options.Find(o => o.Symbol == symbol);
            if (option == null)
            {
                throw new UndefinedOptionException("指定されたオプションは定義されていないため、認識できません。", "-" + symbol);
            }
            return option;
        }

        /// <summary>
        /// 反復処理のための列挙子を取得します。
        /// </summary>
        /// <returns>反復処理のための列挙子。</returns>
        IEnumerator<Option> IEnumerable<Option>.GetEnumerator()
        {
            return this.options.GetEnumerator();
        }

        /// <summary>
        /// 反復処理のための列挙子を取得します。
        /// </summary>
        /// <returns>反復処理のための列挙子。</returns>
        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.options.GetEnumerator();
        }
    }
}
