﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ClipClop.View
{
    public partial class ActiveForm : Form
    {
        public ActiveForm()
        {
            InitializeComponent();
        }

        public void Open()
        {
            this.Visible = true;
            if (this.WindowState == FormWindowState.Minimized)
            {
                // 最小化をやめる
                this.WindowState = FormWindowState.Normal;
            }

            this.Activate();
        }

        protected override void WndProc(ref Message m)
        {
            if ((m.Msg == (int)WinApi.Message.id.WM_SYSCOMMAND) && (m.WParam == (IntPtr)WinApi.Message.wparam.SC_MINIMIZE))
            {
                //最小化ボタンクリックで、FormをHideするだけにする
                base.Hide(); // 隠す 
                return;
            }
            base.WndProc(ref m);
        }

        protected bool CheckClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;						// 終了処理キャンセル
                this.Visible = false;					// フォーム非表示
                return false;
            }
            return true;
        }


    }
}
