﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Diagnostics;
using System.Globalization;
using CaLib.User;
using System.Xml.Schema;
using System.Windows.Forms;
using System.IO;
using ClipClop.Properties;

namespace ClipClop.User
{
	public class XmlContextMenuReader : IContextMenuReader
	{
		XmlDocument doc_;

		public XmlDocument GetDocument()
		{
			return this.doc_;
		}

		/// <summary>
		/// 読み込み処理。何かあると例外投入する。
		/// </summary>
		/// <param name="filePath"></param>
		public void Read(string filePath)
		{
			doc_ = new XmlDocument();

			string xsdPath = Path.Combine(Path.GetDirectoryName(Application.ExecutablePath),Settings.Default.XsdFileName);

			XmlFileReader reader = new XmlFileReader(xsdPath);

			bool ret = reader.Read(doc_,filePath);

			if (ret == false)
			{
				throw new FundamentalException(reader.GetErrorMessage());
			}

			//読み込み後のチェック
			XmlNode root = ContextMenuSettingHelper.GetRoot(doc_);

			Debug.Assert(root != null);

			//不正な場合は例外投入
			ContextMenuSettingHelper.CheckAsRoot(root);
		}

	}
}
