﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ClipClop.User;
using System.IO;
using System.Xml;
using CaLib.User;

namespace ClipClop.View
{
	public partial class TemplateItemForm : Form
	{
		XmlDocument doc_;
		TemplateSettingTreeNode nodeItem_;

		public TemplateItemForm()
		{
			InitializeComponent();
		}


		public TemplateItemForm(XmlDocument doc, TemplateSettingTreeNode nodeItem)
		{
			InitializeComponent();

			this.doc_ = doc;
			this.nodeItem_ = nodeItem;

			this.comboBoxType.DataSource = ContextMenuSettingDefinition.ModeNamestrings;
			this.comboBoxType.ValueMember = "Value";
			this.comboBoxType.DisplayMember = "Key";

			UpdateControls();
		}


		void UpdateControls()
		{
			switch (nodeItem_.Mode)
			{
				case ContextMenuSettingDefinition.Mode.template:
				case ContextMenuSettingDefinition.Mode.execute:
					this.textBoxName.Text = nodeItem_.DispalyName;
					this.textBoxValue.Text = nodeItem_.DispalyValue;
					break;
				case ContextMenuSettingDefinition.Mode.editfile:
				case ContextMenuSettingDefinition.Mode.clipboardhistory:
					this.textBoxName.Text = string.Empty;
					this.textBoxValue.Text = string.Empty;
					break;
			}

			this.comboBoxType.SelectedIndex = (int)nodeItem_.Mode;
		}

		private void comboBoxType_SelectedValueChanged(object sender, EventArgs e)
		{
			ContextMenuSettingDefinition.Mode mode = (ContextMenuSettingDefinition.Mode)this.comboBoxType.SelectedIndex;
			switch (nodeItem_.Mode)
			{
				case ContextMenuSettingDefinition.Mode.template:
				case ContextMenuSettingDefinition.Mode.execute:
					this.textBoxName.Enabled = true;
					this.textBoxValue.Enabled = true;
					break;
				case ContextMenuSettingDefinition.Mode.editfile:
				case ContextMenuSettingDefinition.Mode.clipboardhistory:
					this.textBoxName.Enabled = false;
					this.textBoxValue.Enabled = false;
					break;
			}
		}

		private void buttonOK_Click(object sender, EventArgs e)
		{
			ContextMenuSettingDefinition.Mode mode = (ContextMenuSettingDefinition.Mode)this.comboBoxType.SelectedIndex;
			switch (mode)
			{
				case ContextMenuSettingDefinition.Mode.template:
					if (string.IsNullOrEmpty(this.textBoxValue.Text))
					{
						Util.ShowWarn(global::ClipClop.Properties.Resources.MSG001);
						return;
					}
					//名前は空でもいい
					break;
				case ContextMenuSettingDefinition.Mode.execute:
					if (string.IsNullOrEmpty(this.textBoxName.Text))
					{
						Util.ShowWarn(global::ClipClop.Properties.Resources.MSG002);
						return;
					}
					if (string.IsNullOrEmpty(this.textBoxValue.Text))
					{
						Util.ShowWarn(global::ClipClop.Properties.Resources.MSG001);
						return;
					}

					string exec = ContextMenuSettingHelper.FindExecuteString(this.textBoxValue.Text);
					if (string.IsNullOrEmpty(exec))
					{
						//exeファイルのパスが指定された場合
						//ファイル名に使用できない文字を取得
						char[] invalidChars = Path.GetInvalidFileNameChars();

						if (exec.IndexOfAny(invalidChars) > -1)
						{
							Util.ShowWarn(global::ClipClop.Properties.Resources.MSG003);
							return;
						}
					}

					break;
				case ContextMenuSettingDefinition.Mode.editfile:
				case ContextMenuSettingDefinition.Mode.clipboardhistory:
					break;
			}

			//check -> ok
			if (!nodeItem_.EditAttribute(mode, this.textBoxName.Text, this.textBoxValue.Text, this.doc_))
			{
				throw new FundamentalException(global::ClipClop.Properties.Resources.EA001);
			}

			this.Close();
		}
	}
}
