﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using ClipClop.User;
using ClipClop.Model;
using CaLib.User;
using System.IO;
using System.Xml;
using System.Threading;


namespace ClipClop.View
{
	public partial class MainForm : ActiveForm
	{
		/// <summary>
		/// ホットキーの管理
		/// </summary>
		private CaLib.User.Hotkey hotkeyRegister_;

		/// <summary>
		/// 動作設定
		/// </summary>
		private ClipClop.Model.AplSetting setting_;

        /// <summary>
        /// クリップボード履歴フォーム
        /// </summary>
        private HistoryForm historyForm_;

        /// <summary>
		/// 定型文定義ファイル暗号化時のパスワード。
		/// 暗号化ファイルを使うのであればアプリ起動毎に入力してもらう。
		/// </summary>
		private string templateFilePassword_;

		/// <summary>
		/// クリップボード監視クラス
		/// </summary>
		private CaLib.User.ClipboardViewer cpViewer_;


		/// <summary>
		/// 
		/// </summary>
		ContextMenuSettingManager cntxtMenuSettingManager_ = new ContextMenuSettingManager();

		DynamicContextMenuStrip contextMenuStripPopup_ = null;

		//Load完了後にtrueにする
		bool bReady_ = false;

        
        ScriptManager scriptManager_ = new ScriptManager();

		#region 動作ログ画面
		LogForm logForm_;
		ActionLogManager logManager_ = new ActionLogManager();
		#endregion


        public MainForm()
		{
			Stopwatch sw = new Stopwatch();
			sw.Start();

			InitializeComponent();

			this.ShowInTaskbar = false;

            //枠を消す
            this.FormBorderStyle = FormBorderStyle.None;

            this.TopMost = true;
            //this.ShowInTaskbar = false;
            this.Size = Size.Empty;

			//設定の復元を行う
			setting_ = ClipClop.Model.AplSetting.Create(global::ClipClop.Properties.Settings.Default.AplSetting);

			templateFilePassword_ = null;
        
            this.historyForm_ = new HistoryForm();
            this.OpenToolStripMenuItem.Click += new System.EventHandler(this.historyForm_.Open_Click);
            this.notifyIcon.MouseDoubleClick += new System.Windows.Forms.MouseEventHandler(this.historyForm_.Open_Click);

			cpViewer_ = new CaLib.User.ClipboardViewer(this);
			//cpViewer_.ClipboardHandler += this.OnClipBoardChanged;
			cpViewer_.ClipboardNotifyHandler += this.OnClipBoardNotify;

			this.logForm_ = new LogForm(this.logManager_, this.LogForm_FormClosing);


			sw.Stop();
			logManager_.Add(ActionLogManager.category.action, string.Format("start [{0}msec]",sw.ElapsedMilliseconds ));
		}




        
	    private void MainForm_Load(object sender, EventArgs e)
        {
			Stopwatch sw = new Stopwatch();
			sw.Start();

			//base.OnLoad(e);

			//ホットキーを設定する
			if (!SetupHotkey())
			{
				Util.ShowError(global::ClipClop.Properties.Resources.EF002);
			}

			//設定を反映する
            this.historyForm_.Setup(
				setting_.bAlwaysTop_, setting_.Opacity, setting_.WindowFont_, setting_.MaxHistory, setting_.MaxBufferText, setting_.bUseBufferText_, setting_.imageHistoryOptions_
				);

			if (!File.Exists(this.setting_.templateFilePath_) && !global::ClipClop.Properties.Settings.Default.CopiedInitialTemplate)
			{ 
				//定型文定義ファイルが存在しない場合で、まだ初期ファイルをコピーしていないならば
				string src = Path.Combine( Path.GetDirectoryName(Application.ExecutablePath), "InitialTemplate.xml");
				try
				{
					File.Copy(src, this.setting_.templateFilePath_);
					global::ClipClop.Properties.Settings.Default.CopiedInitialTemplate = true;
				}
				catch (Exception exp1)
				{
					Trace.WriteLine( "初期定型文定義ファイルコピーで例外：" + exp1.Message );
				}
			}

			try
			{
				// 定型文字列ペースト用メニュー

				contextMenuStripPopup_ = new DynamicContextMenuStrip(this.components);

                this.ContextMenuStrip = contextMenuStripPopup_;

				contextMenuStripPopup_.AplSetting = this.setting_;

                contextMenuStripPopup_.Closed += new ToolStripDropDownClosedEventHandler(OnContextMenuClosed);

				//設定ファイル読み込み
				ReadTemplateSettingFile(true);

				if (this.setting_.bInheritHistory_)
				{
                    //履歴の読み込み
                    this.historyForm_.Read(Path.Combine(AplSetting.APP_DATA_FOLDER_, global::ClipClop.Properties.Settings.Default.HistoryFileName));
					this.historyForm_.ReadImage(Path.Combine(AplSetting.APP_DATA_FOLDER_, global::ClipClop.Properties.Settings.Default.ImageFileName));
				}
			}
			catch (Exception exp)
			{
				Util.ShowError(exp.Message);
			}

			if (setting_.bUseBufferText_)
			{
				try
				{
					this.historyForm_.ReadBuffer(Path.Combine(AplSetting.APP_DATA_FOLDER_, global::ClipClop.Properties.Settings.Default.BufferFileName));
				}
				catch (Exception exp)
				{
					Util.ShowError(exp.Message);
				}
			}

            UpdateScriptManager();

			HistoryToolStripMenuItem.Checked = this.cpViewer_.Valid;
			SetNotifyIcon(this.cpViewer_.Valid);

            if (!setting_.bMinimizeOnStart_)
            {
                this.historyForm_.Open();
            }

			Trace.WriteLine("MainForm_Load end");

            //最小化する...なぜ別スレッドから呼ぶ必要があるんだろう？
            (new Thread(new ThreadStart(hideFormThread))).Start();

			bReady_ = true;

			sw.Stop();
			logManager_.Add(ActionLogManager.category.action, string.Format("load [{0}msec]",sw.ElapsedMilliseconds ));
        }

        void UpdateScriptManager()
        {
			this.historyForm_.SetupScriptFiles(this.setting_.sriptFileFolder_, ClipClop.Properties.Settings.Default.LastScriptFilename);

			if (!string.IsNullOrEmpty(this.setting_.sriptFileFolder_))
			{
				try
				{
					scriptManager_.Create();
				}
				catch (Exception scExp)
				{
					Util.ShowError(scExp.Message);
					scriptManager_.Destory();
				}
			}
        }

        #region フォームを閉じる
        delegate void HideFormDelegate();

        void HideForm()
        {
            if (this.InvokeRequired)
            {
                // 別スレッドから呼び出された場合
                Invoke(new HideFormDelegate(HideForm));
                return;
            }
            //see http://dobon.net/vb/dotnet/form/hideformwithtrayicon.html
            this.WindowState = FormWindowState.Minimized;
            this.Hide();
            this.Visible = false;
        }

        void hideFormThread()
        {
            Thread.Sleep(ClipClop.Properties.Settings.Default.WaitBeforeHide);  // Form (起動画面)が消えるまでの時間[ms]の設定
            HideForm();
        }
        #endregion

        /// <summary>
		/// ホットキーを設定する
		/// </summary>
		bool SetupHotkey()
		{
			//ホットキー登録解除
			if (hotkeyRegister_ != null)
			{
				hotkeyRegister_.Clear();
			}

			bool ret = true;
			hotkeyRegister_ = new CaLib.User.Hotkey(this.Handle);

			for (int i = 0; i < setting_.GetHotKeyCount(); i++)
			{
				System.Windows.Forms.Keys s = setting_.GetHotKeyAt(i);
				Debug.WriteLine(string.Format("SetupHotkey[{0}] {1}", i, s.ToString()));

				if (s == Keys.None)
					continue;

				CaLib.User.Hotkey.Input ipt = null;
				
				switch( (AplSetting.Hotkeys)i)
				{
					case AplSetting.Hotkeys.Active:
                        ipt = new Hotkey.Input(s, this.historyForm_.HotkeyEventHandler_Active);
						break;
					case AplSetting.Hotkeys.DeleteHistory:
						ipt = new Hotkey.Input(s, this.historyForm_.HotkeyEventHandler_DeleteHistory);
						break;
					case AplSetting.Hotkeys.TemplatePopup:
						ipt = new Hotkey.Input(s, this.HotkeyEventHandler_TemplatePopup);
						break;
				}
				ret &= hotkeyRegister_.Register(i, ipt);
			}

			return ret;
		}

		#region ホットキーイベント

		void HotkeyEventHandler_TemplatePopup()
        {
            Trace.WriteLine(string.Format("WindowState={0}, Visible={1}", this.WindowState.ToString(), this.Visible));

            if (this.Visible)
                return;//定型文メニュー表示中にホットキーを押された場合を考慮している。

//            IntPtr lastAvtive = FormUtil.GetActiveWindow();
            IntPtr lastAvtive = FormUtil.GetActiveWindow();

			//マウスカーソルの位置を画面座標で取得
			Point mp = Control.MousePosition;

			try
			{
				// 定型文字列ペースト用メニュー

				//設定ファイル読み込み...パスワードが空なら更新する
				bool bNewSetting = ReadTemplateSettingFile(string.IsNullOrEmpty(this.templateFilePassword_));

				if (bNewSetting || contextMenuStripPopup_.Items.Count<1)
				{
					//設定ファイルが新しくなったときだけ、再構築
					contextMenuStripPopup_.ConstructMenu(cntxtMenuSettingManager_,this.historyForm_.History);
				}

				if (contextMenuStripPopup_.Items.Count < 1)
				{
					Util.ShowWarn(global::ClipClop.Properties.Resources.MSG006);
					return;
				}

                contextMenuStripPopup_.LastAvtiveWindow = lastAvtive;

                this.Location = mp;
                base.Open();
			}
			catch(Exception exp)
			{
				Util.ShowError(exp.Message);
			}
			finally
			{
            }
		}

		#endregion

		bool ReadTemplateSettingFile(bool bUpdatePassword)
		{
			bool bReadNewSetting = cntxtMenuSettingManager_.Read(this.setting_.templateFilePath_, ContextMenuSettingManager.FileType.TreeXml);

			if ( bReadNewSetting && cntxtMenuSettingManager_.Document.IsEncrypted())
			{
				//暗号化されている場合

				Debug.Assert(cntxtMenuSettingManager_.Document.Status == XmlCipheredDocument.CipheringStatus.ciphered, this.setting_.templateFilePath_);

				if (bUpdatePassword)
				{
					if (!PasswordForm.ShowInputPassword(ref this.templateFilePassword_))
					{
						throw new FundamentalException(global::ClipClop.Properties.Resources.EF010);
					}
				}

				cntxtMenuSettingManager_.Document.Decrypt(this.templateFilePassword_);
			}

			return bReadNewSetting;
		}


        #region 仮想関数

        protected override void WndProc(ref Message m)
		{
			if (hotkeyRegister_ != null )
			{
				hotkeyRegister_.OnKeyDown(m);
			}

			base.WndProc(ref m);
		}

		#endregion

		#region イベントハンドラー


		/// <summary>
		/// 終了メニュー
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ExitToolStripMenuItem_Click(object sender, EventArgs e)
		{
			// タスクトレイからアイコンを取り除く
			this.notifyIcon.Visible = false;

			// アプリケーション終了
			Application.Exit();
		}

		private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
		{
            if (!base.CheckClosing(sender, e))
            {
                this.notifyIcon.Visible = true;			// Notifyアイコン表示
                //this.notifyIcon.ShowBalloonTip(500); // バルーンTip表示
                return;
            }

			//ホットキー登録解除
			hotkeyRegister_.Clear();

			//設定保存
			Properties.Settings.Default.LastScriptFilename = this.historyForm_.ScriptFile;
			Properties.Settings.Default.Save();

			try
			{
				if (this.setting_.bInheritHistory_)
				{
					//履歴保存
					this.historyForm_.Save(
						Path.Combine(AplSetting.APP_DATA_FOLDER_, global::ClipClop.Properties.Settings.Default.HistoryFileName)
						);

					this.historyForm_.SaveImage(
						Path.Combine(AplSetting.APP_DATA_FOLDER_, global::ClipClop.Properties.Settings.Default.ImageFileName)
						);
				}
			}
			catch (Exception exp)
			{
				Util.ShowError(exp.Message);
			}

			if (setting_.bUseBufferText_)
			{
				try
				{
					this.historyForm_.SaveBuffer(
						Path.Combine(AplSetting.APP_DATA_FOLDER_, global::ClipClop.Properties.Settings.Default.BufferFileName)
						);
				}
				catch (Exception exp)
				{
					Util.ShowError(exp.Message);
				}
			}


            // 終了時、「すぐに」アイコンを消す (念のため)
            this.notifyIcon.Visible = false;
		}

        /// <summary>
        /// ContextMenuが閉じたら呼ばれるようにしているイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void OnContextMenuClosed(object sender, ToolStripDropDownClosedEventArgs e)
        {
            this.Hide();
        }

		/// <summary>
		/// 履歴ON/OFFメニューがクリックされた
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void HistoryToolStripMenuItem_Click(object sender, EventArgs e)
		{
			System.Windows.Forms.ToolStripMenuItem m = sender as System.Windows.Forms.ToolStripMenuItem;
			this.cpViewer_.Valid = m.Checked;
			SetNotifyIcon(m.Checked);
		}

		class AutoMenuItemEnable : IDisposable
		{
			System.Windows.Forms.ToolStripMenuItem menu_;
			public AutoMenuItemEnable(System.Windows.Forms.ToolStripMenuItem menu)
			{
				this.menu_ = menu;
				this.menu_.Enabled = false;
			}

			public void Dispose()
			{
				this.menu_.Enabled = true;
			}
		}

		private void SettingToolStripMenuItem_Click(object sender, EventArgs e)
		{
			string oldTemplate = this.setting_.templateFilePath_;

			using (AutoMenuItemEnable autoMenu = new AutoMenuItemEnable(SettingToolStripMenuItem))
			{
				//アプリケーション設定画面を表示する。
				using (SettingForm sf = new SettingForm(this.setting_, this.templateFilePassword_))
				{
					DialogResult result = sf.ShowDialog();
					if (result == DialogResult.OK)
					{
						this.setting_ = sf.Setting;
						global::ClipClop.Properties.Settings.Default.AplSetting = setting_.ToString();

						//ホットキーを設定する
						if (!SetupHotkey())
						{
							Util.ShowError(global::ClipClop.Properties.Resources.EF002);
						}

						//設定を反映する
						this.historyForm_.Setup(
							setting_.bAlwaysTop_, setting_.Opacity, setting_.WindowFont_, setting_.MaxHistory, setting_.MaxBufferText, setting_.bUseBufferText_, setting_.imageHistoryOptions_
							);

						//パスワードを更新する（コンストラクタで旧を渡してるので、変更に関係なく更新可能）
						this.templateFilePassword_ = sf.Password;

						UpdateScriptManager();
					}
				}
			}
		}

        /// <summary>
        /// 定型文設定メニュー
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void templateToolStripMenuItem_Click(object sender, EventArgs e)
        {
			using (AutoMenuItemEnable autoMenu = new AutoMenuItemEnable(templateToolStripMenuItem))
			{

				using (TemplateSetting dlg = new TemplateSetting(this.setting_.templateFilePath_, this.templateFilePassword_))
				{
					DialogResult result = dlg.ShowDialog();
					if (result == DialogResult.OK)
					{
						this.cntxtMenuSettingManager_.Document = dlg.GetXmlCipheredDocument();
						this.templateFilePassword_ = dlg.PasswordString;

						try
						{
							if (this.cntxtMenuSettingManager_.Document == null)
								throw new FundamentalException(global::ClipClop.Properties.Resources.EA001);

							//バックアップを作成する
							if (this.setting_.bBackup_)
							{
								string backup = GetBackupFileName(this.setting_.templateFilePath_);
								Util.Compress(this.setting_.templateFilePath_, backup);

								DeleteOldBackupFile(backup);
							}

							this.cntxtMenuSettingManager_.Document.SaveTo(this.setting_.templateFilePath_, this.templateFilePassword_);
						}
						catch (Exception exp)
						{
							Util.ShowError(global::ClipClop.Properties.Resources.EF004 + Environment.NewLine + exp.Message);
						}
					}
				}
			}
        }

		public static string GetBackupFileName(string path)
		{
			string noExtName = Path.Combine( Path.GetDirectoryName(path), Path.GetFileNameWithoutExtension(path));

			int i = 0;
			while (true)
			{
				string w = string.Format("{0}{1}_{2}.{3}", noExtName, DateTime.Now.ToString("yyyyMMdd"), i++, ClipClop.Properties.Settings.Default.BackupFileExt);

				if (!File.Exists(w))
					return w;
			}

			throw new FundamentalException(global::ClipClop.Properties.Resources.EA001);
		}

		public static void DeleteOldBackupFile(string currnetBackup)
		{
			string filter = string.Format("*.{0}", ClipClop.Properties.Settings.Default.BackupFileExt);

			string[] files = Directory.GetFiles(Path.GetDirectoryName(currnetBackup), filter);
			foreach (string s in files)
			{
				if (s.Equals(currnetBackup))
					continue;
				try
				{
					File.Delete(s);
				}
				catch (Exception)
				{
					//...何もしない
				}
			}
		}


		private void aboutAToolStripMenuItem_Click(object sender, EventArgs e)
		{
			using( AutoMenuItemEnable autoMenu = new AutoMenuItemEnable(aboutAToolStripMenuItem))
			{
				using (AboutForm f = new AboutForm())
				{
					f.ShowDialog();
				}
			}
		}

		private void helpGToolStripMenuItem_Click(object sender, EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start(ClipClop.Properties.Resources.ProjectPage);
			}
			catch (Exception exp)
			{
				Util.ShowError(exp.Message);
			}
		}

		#endregion

        private void MainForm_Activated(object sender, EventArgs e)
        {
            if( this.ContextMenuStrip != null)
                this.ContextMenuStrip.Show(Control.MousePosition);
        }

        private void MainForm_Deactivate(object sender, EventArgs e)
        {
            if (this.ContextMenuStrip.Visible == false)
            {
                //ContextMenuのアイテムが選択された
            }
            else
            {
                //フォーカスが外れた
                this.Close();
            }
        }

		static NotifyIconTimer notifyIconTimer_ = new NotifyIconTimer();

		///// <summary>
		///// クリップボードにテキストがコピーされると呼び出される
		///// </summary>
		///// <param name="sender"></param>
		///// <param name="args"></param>
		//private void OnClipBoardChanged(object sender, CaLib.User.ClipboardEventArgs args)
		//{
		//    string input = args.Text;
		//
		//    if (this.cpViewer_.Valid && false == string.IsNullOrEmpty(input))
		//    {
		//        if (scriptManager_.Valid && 
		//            string.IsNullOrEmpty(this.historyForm_.ScriptFile) == false &&
		//            string.IsNullOrEmpty(this.setting_.sriptFileFolder_) == false ) 
		//        {
		//            try
		//            {
		//                string file = Path.Combine(this.setting_.sriptFileFolder_, this.historyForm_.ScriptFile);
		//                input = scriptManager_.Execute(file, "clipboard_text", input);
		//            }
		//            catch (Exception exp)
		//            {
		//                Trace.WriteLine(exp.Message);
		//
		//                //Util.ShowError(exp.Message);
		//                input = args.Text;
		//            }
		//        }
		//
		//        historyForm_.InsertHead(input);
		//
		//        if (bReady_ && notifyIconTimer_.IsWorkiing == false )
		//        {
		//            Debug.Assert(this.notifyIcon.Icon != null);
		//
		//            //ちょっと待ってから元のアイコンに戻す
		//            notifyIconTimer_.prev_ = SwapNotifyIcon(ClipClop.Properties.Resources.paste_yellow);
		//            notifyIconTimer_.Tick += new EventHandler(NotifyIconClock);
		//            notifyIconTimer_.working_ = true;
		//            notifyIconTimer_.Start();
		//        }
		//    }
		//    else
		//    {
		//        Trace.WriteLine(string.Format("NOT insert to list {0}.", string.IsNullOrEmpty(input) ? "null" : input));
		//    }
		//}

		#region NotifyIcon操作

		class NotifyIconTimer : System.Windows.Forms.Timer
		{
			public Icon prev_;
			public bool working_;

			public bool IsWorkiing
			{
				get
				{
					return this.working_;
				}
			}

			public NotifyIconTimer()
			{
				working_ = false;
				this.Interval = ClipClop.Properties.Settings.Default.BlickNotifyIconInterval;
			}
		}

		public void NotifyIconClock(object sender, EventArgs e)
		{
			NotifyIconTimer t = sender as NotifyIconTimer;
			if (t != null)
			{
				t.Stop();
			}
			SwapNotifyIcon(t.prev_);
			notifyIconTimer_.working_ = false;
		}

		private Icon SwapNotifyIcon(Icon ic)
		{
			Icon prev = this.notifyIcon.Icon;
			this.notifyIcon.Icon = ic;
			return prev;
		}

		private void SetNotifyIcon(bool bActive)
		{
			if (bActive)
			{
				this.notifyIcon.Icon = ClipClop.Properties.Resources.pasteActive;
			}
			else
			{
				this.notifyIcon.Icon = ClipClop.Properties.Resources.pasteDark;
			}
		}
		#endregion

		private bool ImageToHistory(Image copiedImage )
		{
			if (!bReady_)
				return false;//Load完了前は何もしない

			try
			{
				Trace.WriteLine("MainForm.ImageToHistory [");

				historyForm_.listBoxPicture.InsertHead(copiedImage);
			}
			catch (Exception exp)
			{
				//TODO メッセージ
				Util.ShowError(/*global::ClipClop.Properties.Resources.xxxx + */Environment.NewLine + exp.Message);
				return false;
			}
			finally 
			{
				Trace.WriteLine("MainForm.ImageToHistory ]");
			}
			return true;
		}


		private bool TextToHistory(string buffer )
		{
			string input = buffer;

			if ( false == string.IsNullOrEmpty(input) )
			{
				if (scriptManager_.Valid &&
					string.IsNullOrEmpty(this.historyForm_.ScriptFile) == false &&
					string.IsNullOrEmpty(this.setting_.sriptFileFolder_) == false)
				{
					//TODO ここで処理に時間がかかると、応答なしになるかも（なるだろうなぁ）
					try
					{
						string file = Path.Combine(this.setting_.sriptFileFolder_, this.historyForm_.ScriptFile);
						input = scriptManager_.Execute(file, "clipboard_text", input);
					}
					catch (Exception exp)
					{
						Trace.WriteLine(exp.Message);

						logManager_.Add(ActionLogManager.category.script, exp.Message);

						//Util.ShowError(exp.Message);
						input = buffer;
					}
				}

				historyForm_.InsertHead(input);

				//logManager_.Log = string.Format("copied {0}", input);

				return true;
			}

			Trace.WriteLine(string.Format("NOT insert to list {0}.", string.IsNullOrEmpty(input) ? "null" : input));
			return false;
		}

		private void BlinkIcon()
		{
			if (bReady_ && notifyIconTimer_.IsWorkiing == false)
			{
				Debug.Assert(this.notifyIcon.Icon != null);

				//ちょっと待ってから元のアイコンに戻す
				notifyIconTimer_.prev_ = SwapNotifyIcon(ClipClop.Properties.Resources.paste_yellow);
				notifyIconTimer_.Tick += new EventHandler(NotifyIconClock);
				notifyIconTimer_.working_ = true;
				notifyIconTimer_.Start();
			}
		}

		private bool OnClipBoardNotifyFileDrioList(CaLib.User.ClipboardEventNotifyArgs args)
		{
			if (args.fileDropList_ == null)
				return false;

			foreach (string s in args.fileDropList_)
			{
				if (string.IsNullOrEmpty(s))
					continue;
				TextToHistory(s);
			}

			return true;
		}

		private void OnClipBoardNotify(object sender, CaLib.User.ClipboardEventNotifyArgs args)
		{
			if (args.dataObject_ != null)
			{
				Trace.WriteLine(string.Format("MainForm.OnClipBoardNotify({0},{1})",args.division_.ToString(),args.dataObject_.GetHashCode()));

				Trace.Indent();
				foreach (string s in args.dataObject_.GetFormats())
				{
					Trace.WriteLine(s);
				}
				Trace.Unindent();
			}

			if (!this.cpViewer_.Valid)
				return;//クリップボードの監視が無用なら何もしない

			bool bSuccess = false;
			switch (args.division_)
			{
				case ClipboardEventNotifyArgs.MajorDivision.text:
					//これは有効無効のチェックなし
					bSuccess = TextToHistory(args.text_);
					break;
				case ClipboardEventNotifyArgs.MajorDivision.fileDropList:
					if (setting_.bCheckFileList_ == false)
						return;
					bSuccess = OnClipBoardNotifyFileDrioList(args);
					break;
				case ClipboardEventNotifyArgs.MajorDivision.image:
					if (setting_.imageHistoryOptions_.bEnable_ == false)
						return;
					bSuccess = ImageToHistory( args.image_);
					
					break;
			}	
		
			if( bSuccess )
				BlinkIcon();
		}


		private void 動作ログToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (this.logForm_ == null)
			{
				this.logForm_ = new LogForm(this.logManager_, this.LogForm_FormClosing);
			}

			logForm_.Show();
		}

		private void LogForm_FormClosing(object sender, FormClosingEventArgs e)
		{
			this.logForm_ = null;
		}




		private void contextMenuStrip_Opening(object sender, CancelEventArgs e)
		{
			if (this.historyForm_ != null && this.historyForm_.Visible)
				this.OpenToolStripMenuItem.Enabled = false;
			else
				this.OpenToolStripMenuItem.Enabled = true;

			if (this.logForm_ != null && this.logForm_.Visible)
				this.動作ログToolStripMenuItem.Enabled = false;
			else
				this.動作ログToolStripMenuItem.Enabled = true;
		}



	
	}
}
