﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Xml.Serialization;
using System.IO;
using System.Diagnostics;
using CaLib.User;

namespace ClipClop.View
{
	public class ClipboardListBox : ReservableListBox
	{
		public ClipboardListBox()
		{
			this.MouseDoubleClick += new System.Windows.Forms.MouseEventHandler(this.OnMouseDoubleClick);
		}

		private void OnMouseDoubleClick(object sender, MouseEventArgs e)
		{
			MoveHead(false);
		}

		/// <summary>
		/// 選択項目を先頭に移動する。
		/// </summary>
		public void MoveHead(bool bRemoveNewLine )
		{
			string text = this.SelectedItem.ToString();

			if (string.IsNullOrEmpty(text))
				return;

			if (bRemoveNewLine)
			{
				text = text.Replace(Environment.NewLine,string.Empty);
			}

			DataObject data = new DataObject();
			data.SetData(text);

			DeleteSelectedItem();

			try
			{
				ClipboardAdapter.SetDataObject(data, true);
			}
			catch (ExternalException)
			{
				//何もしない。
			}
		}


		public override void InsertHead(object s)
		{
			//先頭と同じ文字列は挿入しない
			if (this.Items.Count > 0)
			{
				string head = this.Items[0].ToString();
				if (!string.IsNullOrEmpty(head) && head.Equals(s))
				{
					return;
				}
			}

			base.InsertHead(s);
		}
	}
}
