﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CaLib.User.PropertyGridUtil
{
	/// <summary>
	/// プロパティ表示名を外部から設定するための属性。
	/// </summary>
	[AttributeUsage(AttributeTargets.Property)]
	public class PropertyDisplayNameAttribute : Attribute
	{
		private string myPropertyDisplayName;

		public PropertyDisplayNameAttribute(string name)
		{
			myPropertyDisplayName = name;
		}

		public string PropertyDisplayName
		{
			get { return myPropertyDisplayName; }
		}
	}
}
