//
//  DiracStatusXMLParser.m
//  Dirac
//
//  Created by Ichi Kanaya on 11/04/21.
//  Copyright 2011 大阪大学. All rights reserved.
//

#import "DiracStatusXMLParser.h"

@implementation DiracStatusXMLParser

@synthesize currentXpath;
@synthesize statuses;
@synthesize currentStatus;
@synthesize textNodeCharacters;

- (id)init {
    self = [super init];
    if (self) {
        // Initialization code here.
    }
    return self;
}

- (void) dealloc {
    [currentXpath release];
    [statuses release];
    [currentStatus release];
    [textNodeCharacters release];
    [super dealloc];
}

- (void)parserDidStartDocument: (NSXMLParser *)parser {
    self.currentXpath = [[[NSMutableString alloc]init] autorelease];
    self.statuses = [[[NSMutableArray alloc] init] autorelease];
}

- (void)parser: (NSXMLParser *)parser didStartElement: (NSString *)elementName namespaceURI: (NSString *)namespaceURI qualifiedName:(NSString *)qName attributes: (NSDictionary *)attributeDict {
    [self.currentXpath appendString: elementName];
    [self.currentXpath appendString: @"/"];
    
    self.textNodeCharacters = [[[NSMutableString alloc] init] autorelease];
    
    if ([self.currentXpath isEqualToString: @"statuses/status/"]) {
        self.currentStatus = [[[NSMutableDictionary alloc] init] autorelease];
    }
}

- (void)parser: (NSXMLParser *)parser didEndElement: (NSString *)elementName namespaceURI: (NSString *)namespaceURI qualifiedName: (NSString *)qName {
    NSString *textData = [self.textNodeCharacters stringByTrimmingCharactersInSet: [NSCharacterSet whitespaceAndNewlineCharacterSet]];
    
    if ([self.currentXpath isEqualToString: @"statuses/status/"]) {
        [self.statuses addObject: self.currentStatus];
        self.currentStatus = nil;
        
    }
    else if ([self.currentXpath isEqualToString: @"statuses/status/created_at/"]) {
        [self.currentStatus setValue: textData forKey: @"created_at"];
    }
    else if ([self.currentXpath isEqualToString: @"statuses/status/text/"]) {
        [self.currentStatus setValue: textData forKey: @"text"];
        
    }
    else if ([self.currentXpath isEqualToString: @"statuses/status/user/name/"]) {
        [self.currentStatus setValue: textData forKey: @"name"];
    }
    
    unsigned long delLength = [elementName length] + 1;
    unsigned long delIndex = [self.currentXpath length] - delLength;
    
    [self.currentXpath deleteCharactersInRange: NSMakeRange(delIndex, delLength)];
}

- (void) parser:(NSXMLParser *)parser foundCharacters: (NSString *)string {
    [self.textNodeCharacters appendString:string];
}

- (NSArray *)parseStatuses: (NSData *)xmlData {
    NSXMLParser *parser = [[[NSXMLParser alloc] initWithData:xmlData] autorelease];
    [parser setDelegate: self];
    [parser parse];
    return self.statuses;
}

@end
