class DaxuController < ApplicationController
  layout "main"

  def index
    vols = DxVolume.find(:all)
    @vols = Array.new
    vols.each do |vol|
      voltitle = get_voltitle(vol)
      radicals = DxRadical.find(:all, :conditions =>
                                ["volume_id = ?", vol.id])
      @vols.push([voltitle, radicals])
    end
  end
  def radical
    radical_id = params[:id]
    @radical = DxRadical.find(:first, :conditions => ["id = ?", radical_id])
    @volume = DxVolume.find(:first, :conditions => ["id = ?", @radical.volume_id])
    @wordheads = DxWordhead.find(:all, :conditions => ["radical_id = ?", radical_id])
  end
  def word
    c = params[:char]
    return nil unless c
    (@ucs, @char) = process_char(c)

    @dx_words = Array.new
    wordheads = DxWordhead.find(:all, :conditions => ["name = ?", @char])
    wordheads.each do |word|
      wordid = word.wordid
      rad = DxRadical.find(:first, :conditions => ["id = ?", word.radical_id])
      vol = DxVolume.find(:first, :conditions => ["id = ?", rad.volume_id])
      @dx_words.push([vol, rad, word])
    end

    @extext = params[:extext]
    return nil unless @extext
    @dxexp_words = Array.new
    @pattern = sprintf("%%%s%%", @extext)
    wordheads = DxWordhead.find_by_sql(["select * from dx_wordheads " +
                                       "where exp like ?", @pattern])
    wordheads.each do |word|
      wordid = word.wordid
      rad = DxRadical.find(:first, :conditions => ["id = ?", word.radical_id])
      vol = DxVolume.find(:first, :conditions => ["id = ?", rad.volume_id])
      voltitle = get_voltitle(vol)
      exp = hilighted_exp(word.exp, @extext)
      @dxexp_words.push([voltitle, rad, word, exp])
    end
  end
  def get_voltitle(vol)
    return vol.title.sub(/說文解字第/u, "")
  end
  def hilighted_exp(exp, pattern)
#    span = "<span style='background-color:peachpuff;'>%s</span>"
    span = "<span style='background-color:lightpink;'>%s</span>"
    replaced = sprintf(span, pattern)
    return exp.sub(/#{pattern}/u, replaced)
  end
end
