require 'rexml/document'
UCS = /^[0-9a-fA-F]+$/
CODEPOINT = /^U\+[0-9a-fA-F]+$/

class ApplicationController < ActionController::Base
  helper :all # include all helpers, all the time
  protect_from_forgery # See ActionController::RequestForgeryProtection for details

  # Scrub sensitive parameters from your log
  # filter_parameter_logging :password

  def ucs2char(ucs)
    return nil unless ucs =~ CODEPOINT
    code = ucs.slice(2, ucs.size)
    return code2char(code)
  end
  def code2char(code)
    return [code.hex].pack("U*")
  end
  def char2ucs(char)
    # TODO: Check char in codespace
    # Unicode codespace is a range of integers
    # from 0 to 10FFFF_hex
    return format("U+%04X", char.unpack("U")[0])
  end
  def codepoint2ucs(codepoint)
    return format("U+%04X", codepoint)
  end
  def ucs2codepoint(ucs)
    return nil unless ucs =~ CODEPOINT
    code = ucs.slice(2, ucs.size)
    return code.hex
  end
  def process_char(c)
    if c =~ UCS then
      ucs = "U+" + c
      char = ucs2char(ucs)
    else
      char = c
    end
    return [char2ucs(char), char]
  end

  def print_note(note)
    doc = REXML::Document.new note
    doc.elements.each("//original_text") do |original|
      original.elements.each("//rewrite_text") do |rewrite|
        if rewrite then
          rtext = rewrite.text
          relem = REXML::Element.new("span")
          relem.add_attribute("style", "font_color:red")
          relem.add_text(rtext)
          original.parent.insert_after(original, relem)
        end
      end
      otext = original.text
      replace = REXML::Element.new("del")
      replace.add_text(otext)
      original.parent.replace_child(original, replace)
    end
    return doc.to_s
  end
end
