# Methods added to this helper will be available to all templates in the application.

require 'rubygems'
require 'image_size'

IMG_DIR = File.join(File.dirname(__FILE__), '..', '..', 'public', 'images')

module ApplicationHelper
  def sw_image_size(filename)
    (width, height) = get_image_size(filename)
    return sprintf("%sx%s", width / 2, height / 2)
  end
  def sw_image_small_size(filename)
    (width, height) = get_image_size(filename)
    return sprintf("%sx%s", width / 3, height / 3)
  end
  private
  def get_image_size(filename)
    file = File.open(File.join(IMG_DIR, filename))
    return ImageSize.new(file).get_size
  end
end
