# The first page of volumes
VOLUMES = [811, 1545, 2267, 2931, 3565, 4281, 4811]

class UnihanController < ApplicationController
  layout "main"

  def index
    redirect_to(:controller => 'hanmorph', :action => 'index')
  end
  def hdz
    @char = params[:char]
    @appendix = params[:appendix]
    page = params[:page]
    @page = process_page(page)
    if request.post? then
      @hdz_errors = []
      check_target(@char, page, @appendix)
      if @hdz_errors.empty? then
        main_procedure
      end
    else
      main_procedure
    end
  end

  private
  def main_procedure
    @found = true
    return unless @char or @page
    if @char and @char.length > 0 then
      property = search_hdz_page(@char)
      if property then
        (page, appendix) = get_hdz_index(property)
        make_hdz_page(page, appendix)
        set_navigation(page, appendix)
      else
        @found = false
      end
    else
      make_hdz_page(@page, @appendix)
      set_navigation(@page, @appendix)
    end
  end
  def check_target(char, page, appendix)
    if char and page then
      if char.empty? and page.empty? then
        @hdz_errors << "検索条件を入力して下さい。"
        return
      end
    end
    if char and char.size > 0 then
      check_char(char)
    elsif page then
      check_page(page, appendix)
    end
  end
  def check_page(page, appendix)
    if page =~ /[0-9]+/ then
      pagenum = page.to_i
      if appendix then
        unless 7 <= pagenum.to_i and pagenum <= 44 then
          @hdz_errors << "補遺は#{page}頁にありません。7から44を指定して下さい。"
        end
      else
        unless 1 <= pagenum.to_i and pagenum <= 4810 then
          @hdz_errors << "#{page}頁は存在しません。1から4810を指定して下さい。"
        end
      end
    else
      @hdz_errors << "#{page}は不正な頁数です。"
    end
  end
  def check_char(char)
    if char =~ UCS then
      cp = ucs2codepoint("U+#{char}")
      @hdz_errors << "#{char}は不正なコードポイントです。" if 0x10ffff < cp
    end
  end

  def page2volume(page, appendix)
    return "8" if appendix
    pnum = page.to_i
    volume = 1
    VOLUMES.each do |vpage|
      next if  pnum < vpage
      volume += 1
    end
    return volume.to_s
  end
  def process_char(c)
    if c =~ UCS then
      ucs = "U+" + c
      char = ucs2char(ucs)
    else
      char = c
    end
    return [char2ucs(char), char]
  end
  def make_hdz_page(page, appendix)
    @chars = Array.new
#    hanyu = Field.find(:first, :conditions => ["name = 'kHanYu'"])
    hanyu = Field.find(:first, :conditions => ["name = 'kIRGHanyuDaZidian'"])
    if appendix then
      props = Property.find(:all,
                            :conditions => ["value like ? and field_id = ?", "8#{page}.%%0", hanyu.id],
                            :order => "value")
    else
      props = Property.find(:all,
                            :conditions => ["value like ? and value not like ? and field_id = ?", "%#{page}.%%0", "8%%%%.%%%", hanyu.id],
                            :order => "value")
    end
    props.each do |prop|
      ideograph = Ideograph.find(:first, :conditions => ["id = ?", prop.ideograph_id])
      point = ideograph.codepoint
      char = ucs2char(codepoint2ucs(point))
      @chars.push(char)
    end
    return props[0]
  end
  def set_navigation(page, appendix)
    @page = page
    @appendix = appendix
    @volume = page2volume(page, appendix)
    @next = format("%d", page.to_i + 1)
    @previous = format("%d", page.to_i - 1)
  end
  def search_hdz_page(c)
    (@ucs, @char) = process_char(c)
    cp = ucs2codepoint(@ucs)
    ideograph = Ideograph.find(:first, :conditions => ["codepoint = ?", cp])
    return nil unless ideograph
    property = unihan_lookup(ideograph, 'kIRGHanyuDaZidian')
    return property
  end
  def process_page(p)
    return nil unless p
    return nil unless p =~ /[0-9]+/
    return format("%04d", p.to_i)
  end
  def unihan_lookup(ideograph, field_name)
    field = Field.find(:first, :conditions => ["name = ?", field_name])
    property = Property.find(:first,
                             :conditions => ["field_id = ? and ideograph_id = ?", field.id, ideograph.id])
    return property
  end
  def get_hdz_index(property)
    return nil unless property
    if property.value =~ /([1-8])([0-9]{4})\.([0-3][0-9])[01]/ then
      volume = $1
      page = $2
#      num = $3.to_i
      appendix = (volume == "8" ? true : false)
      return [page, appendix, volume]
    end
  end
end
