DATA_DIR = File.join(File.dirname(__FILE__), '..', '..', 'config', 'data')
SWFONT = File.join(DATA_DIR, 'swfont.txt')

class ShuowenController < ApplicationController
  layout "main"
  caches_page :index
  caches_action :index

  def index
    chapters = SwChapter.find(:all)
    @chapters= Array.new
#    @options = Array.new
#    @chapters.each do |chapter|
#      @options.push([chapter.name, chapter.xmlid])
#    end
#    chapter = params[:chapter]
#    return nil unless chapter
#    @chapter = SwChapter.find(:first, :conditions => ["xmlid = ?", chapter])
    chapters.each do |chapter|
      radicals = SwRadical.find(:all, :conditions =>
                                ["chapter_id = ?", chapter.id])
      @chapters.push([chapter, radicals])
    end
  end
  def radical
    radical_id = params[:id]
    return nil unless radical_id
    @radical = SwRadical.find(:first, :conditions => ["id = ?", radical_id])
    @chapter = SwChapter.find(:first, :conditions => ["id = ?", @radical.chapter_id])
    chars = SwCharacter.find(:all, :conditions => ["radical_id = ?", radical_id])
    @characters = Array.new
    chars.each do |char|
      word = SwWordhead.find(:first, :conditions => ["wordid = ?", char.wordid])
      @characters.push([char, word])
    end
  end
  def character
    character_id = params[:id]
    return nil unless character_id
#    c = params[:character]
#    return nil unless character_id and c
#    if character_id then
      @character = SwCharacter.find(:first, :conditions => ["id = ?", character_id])
#    else
#      (ucs, char) = process_char(c)
#      wordhead = SwWordhead.find(:first, :conditions => ["name = ?", char])
#      @character = SwCharacter.find(:first, :conditions => ["id =?", wordhead.character_id])
#    end
    @radical = SwRadical.find(:first, :conditions => ["id = ?", @character.radical_id])
    @chapter = SwChapter.find(:first, :conditions => ["id = ?", @radical.chapter_id])

    @wordheads = SwWordhead.find(:all, :conditions => ["character_id = ?", character_id])
  end

  def setup
    @chapters = 0
    @radicals = 0
    @characters = 0
    @wordheads = 0
    setup_chapters
    setup_radicals
    setup_characters
    setup_wordheads
  end
  def setup_swfont
    @wordheads = 0
    File.open(SWFONT) do |file|
      file.readlines.each do |line|
        line.chomp!
        (code, wid, chars) = line.split(/\t/)
        if wid =~ /[0-9]{7}/ then
          wordid = "w#{wid}"
          wordhead = SwWordhead.find(:first,
                                   :conditions => ["wordid = ?", wordid])
          wordhead.sw = code2char(code)
          wordhead.save!
          @wordheads += 1
        end
      end
    end
  end

  private
  def setup_chapters
    SwChapter.find(:all).each do |chapter|
      chapter.name = chapter.title + chapter.note
      chapter.save!
      @chapters += 1
    end
  end
  def setup_radicals
    SwRadical.find(:all).each do |radical|
      wordid = radical.wordid
      character = SwCharacter.find(:first,
                                   :conditions => ['wordid = ?', wordid])
      wordhead = SwWordhead.find(:first,
                                 :conditions => ['wordid = ?', wordid])
      radical.name = wordhead.name
      radical.character_id = character.id
      radical.save!
      @radicals += 1
    end
  end
  def setup_characters
    SwCharacter.find(:all).each do |character|
      wordid = character.wordid
      radical_id = get_radical_id(wordid)
      radical = SwRadical.find(:first,
                                 :conditions => ['wordid = ?', radical_id])
      wordhead = SwWordhead.find(:first,
                                 :conditions => ['wordid = ?', wordid])
      character.name = wordhead.name
      character.radical_id = radical.id
      #
      # Adds wordhead_id:references
      #      character.wordhead_id = wordhead.id
      character.save!
      @characters += 1
    end
  end
  def setup_wordheads
    SwWordhead.find(:all).each do |wordhead|
      charid = get_charid(wordhead.wordid)
      character = SwCharacter.find(:first,
                                   :conditions => ['wordid = ?', charid])
      wordhead.character_id = character.id
      wordhead.save!
      @wordheads += 1
    end
  end
  def get_radical_id(wordid)
    wordid =~ /^(w[0-9]{3}).{4}$/
    return $1 + "0010"
  end
  def get_charid(wordid)
    wordid =~ /^(w[0-9]{6}).$/
    return $1 + "0"
  end
end
