TBL_DIR = File.join(File.dirname(__FILE__), '..', '..', 'config', 'table')
XS = File.join(TBL_DIR, 'phonetic_components.yml')
MAX_NUM_FOR_MATCHED = 100

class HanmorphController < ApplicationController
  layout "main"
  caches_page :xiesheng, :rime_groups
  caches_action :xiesheng, :rime_groups
  
  def index
    if request.post? then
      @errors = []
      (@ucs, @char, @extext) = check_targets
#      raise Exception
      if @errors.empty? then
        begin
          main_procedure_at_home
        rescue StandardError => bang
          @message = bang.message
        end
      end
    else
      char = params[:char]
      (@ucs, @char) = process_char(char) if char
      main_procedure_at_home
    end
  end
  def rime_groups
    @groups = Array.new
    volumes = Volume.find(:all)
    groups = RimeGroup.find(:all)
    #groups.sort! {|a,b| a.num <=> b.num}
    groups.each do |group|
      sisheng = Array.new(4)
      volumes.each do |volume|
        rhymes = Rhyme.find(:all, :conditions => 
                            ["rime_group_id = ? and volume_id = ?", group.id, volume.id])
        volume
        if volume.name =~ /[上下]平聲/u then
          sisheng[0] = Array.new unless sisheng[0] 
          sisheng[0] += rhymes
        elsif volume.name =~ /上聲/u then
          sisheng[1] = rhymes
        elsif volume.name =~ /去聲/u then
          sisheng[2] = rhymes
        elsif volume.name =~ /入聲/u then
          sisheng[3] = rhymes
        end
      end
      @groups.push([group, sisheng])
    end
  end
  def xiesheng
    @doc = YAML.load(File.new(XS))
#    doc.each_key do |group|
#      doc[group].each_key do |xs|
#        doc[group][xs].each do |char|
#    end
  end
  def pcomponent
    @group = params[:group]
    @xiesheng = params[:xiesheng]
    doc = YAML.load(File.new(XS))
    @chars = doc[@group][@xiesheng]
  end
  def explanation
  end
  
  private
  def main_procedure_at_home
    if @char then
      process_unihan
      process_sbgy
      process_dianzhu
      process_daxu
    end
    if @extext then
      begin
        search_daxu
      rescue TooManyCandidatesError => bang
        @errors << bang
      end
    end
  end

  # Validation Input Parameters
  def check_targets
    c = params[:char]
    extext = params[:extext]
    # TODO: 不正な文字のチェック
    if extext and extext.size == 0 then
      @errors << "検索する説解が入力されていません"
    elsif ! extext and c and c.size == 0 then
      @errors << "検索する文字が入力されていません"
    elsif c =~/[0-9A-Fa-f]+/ and not c =~ /[0-9A-Fa-f]{4,5}/ then
      @errors << "#{c}: 正しいコードポイントではありません"
    else
      (ucs, char) = process_char(c)
      return [ucs, char, extext]
    end
  end

  # Main Procesures
  def process_unihan
    cp = ucs2codepoint(@ucs)
    ideograph = Ideograph.find(:first, :conditions => ["codepoint = ?", cp])
    return nil unless ideograph
    @sbgy = unihan_lookup(ideograph, 'kSBGY')
    @hdz = unihan_lookup(ideograph, 'kHanYu')
    @dkz = unihan_lookup(ideograph, 'kIRGDaiKanwaZiten')
    @kx = unihan_lookup(ideograph, 'kIRGKangXi')
    (@page, @appendix) = get_hdz_page(@hdz)
  end
  def process_sbgy
    @chars = Array.new
    wordheads = Wordhead.find(:all, :conditions => ["name = ?", @char])
    wordheads.each do |wordhead|
      voice = Voice.find(:first, :conditions => ["id = ?", wordhead.voice_id])
      rhyme = Rhyme.find(:first, :conditions => ["id = ?", voice.rhyme_id])
      rime_group = RimeGroup.find(:first, :conditions =>
                                  ["id = ?", rhyme.rime_group_id])
      volume = Volume.find(:first, :conditions => ["id = ?", rhyme.volume_id])
      @chars.push([wordhead, voice, rhyme, rime_group, volume])
    end
  end
  def process_dianzhu
    @sw_chars = Array.new
    wordheads = SwWordhead.find(:all, :conditions => ["name = ?", @char])
    wordheads.each do |wordhead|
      charid = wordhead.character_id
      char = SwCharacter.find(:first, :conditions => ["id = ?", charid])
      rad = SwRadical.find(:first, :conditions => ["id = ?", char.radical_id])
      chap = SwChapter.find(:first, :conditions => ["id = ?", rad.chapter_id])
      words = SwWordhead.find(:all, :conditions => ["character_id = ?", charid])
      @sw_chars.push([chap, rad, char, words])
    end
  end
  def process_daxu
    @dx_words = Array.new
    wordheads = DxWordhead.find(:all, :conditions => ["name = ?", @char])
    wordheads.each do |word|
      wordid = word.wordid
      rad = DxRadical.find(:first, :conditions => ["id = ?", word.radical_id])
      vol = DxVolume.find(:first, :conditions => ["id = ?", rad.volume_id])
      @dx_words.push([vol, rad, word])
    end
  end
  def search_daxu
    @dxexp_words = Array.new
    @pattern = sprintf("%%%s%%", @extext)
    wordheads = DxWordhead.find_by_sql(["select * from dx_wordheads " +
                                       "where exp like ?", @pattern])
    searched = wordheads.size
    if searched > MAX_NUM_FOR_MATCHED then
      raise TooManyCandidatesError, "#{searched}件、見付かりました。検索条件を絞り込んでください。"
    end
    wordheads.each do |word|
      wordid = word.wordid
      rad = DxRadical.find(:first, :conditions => ["id = ?", word.radical_id])
      vol = DxVolume.find(:first, :conditions => ["id = ?", rad.volume_id])
      voltitle = get_voltitle(vol)
      exp = hilighted_exp(word.exp, @extext)
      @dxexp_words.push([voltitle, rad, word, exp])
    end
  end

  # Utility Functions
  def unihan_lookup(ideograph, field_name)
    field = Field.find(:first, :conditions => ["name = ?", field_name])
    property = Property.find(:first,
                             :conditions => ["field_id = ? and ideograph_id = ?", field.id, ideograph.id])
    return property
  end
  def get_hdz_page(property)
    return nil unless property
    if property.value =~ /([1-8])([0-9]{4})\.([0-3][0-9])[01]/ then
      volume = $1
      page = $2
#      num = $3.to_i
      appendix = (volume == "8" ? true : false)
      return [page, appendix, volume]
    end 
  end
  def get_voltitle(vol)
    return vol.title.sub(/說文解字第/u, "")
  end
  def hilighted_exp(exp, pattern)
    regex = pattern.gsub(/%/, ".+")
    # BUG: マッチした文字列が異なる場合、最初のものに置換される
    if exp =~ /#{regex}/u then
      span = "<span style='background-color:lightpink;'>#{$&}</span>"
      return exp.gsub(/#{regex}/u, span)
    else
      return exp
    end

  end
end

class TooManyCandidatesError < RuntimeError
end
