require File.join(File.dirname(__FILE__), '..', 'lib', 'unicode')
require 'test/unit'
ONE_UCS = "U+4E00"

class UnicodeUtilityTest < Test::Unit::TestCase
  def setup
    @unicode = UnicodeUtility.new
  end
  def test_next_codepoint
    first_a = CJK_UNIFIED_EXT_A[0]
    last_a = CJK_UNIFIED_EXT_A[1]
    first_cjk = CJK_UNIFIED[0]
    last_cjk = CJK_UNIFIED[1]
    first_b = CJK_UNIFIED_EXT_B[0]
    last_c = CJK_UNIFIED_EXT_C[1]

    assert_equal first_a + 1, @unicode.nextCodepoint(first_a)
    assert_equal first_cjk, @unicode.nextCodepoint(last_a)
    assert_equal first_cjk + 1, @unicode.nextCodepoint(first_cjk)
    assert_equal first_b, @unicode.nextCodepoint(last_cjk)
    assert_equal nil, @unicode.nextCodepoint(last_c)
  end
  def test_ucs2char
    assert_equal "一", @unicode.ucs2char(ONE_UCS)
    assert_equal "丁", @unicode.ucs2char("U+4E01")
    assert_equal nil, @unicode.ucs2char("4E01")
    assert_equal nil, @unicode.ucs2char("")
  end
  def test_char2ucs
    assert_equal ONE_UCS, @unicode.char2ucs("一")
    assert_equal "U+4E01", @unicode.char2ucs("丁")
    assert_equal "U+20000", @unicode.char2ucs("𠀀")
    # TODO: codespace(a range of integers from 0 to 10FFFF_hex)
    assert_equal "U+0000", @unicode.char2ucs("")
  end
  def test_codepoint2ucs
    assert_equal ONE_UCS, @unicode.codepoint2ucs(0x4E00)
  end
  def test_ucs2codepoint2
    assert_equal 0x4E00, @unicode.ucs2codepoint(ONE_UCS)
  end
  def test_char2codepoint
    assert_equal 0x4E00, @unicode.char2codepoint('一')
    assert_equal 0x3400, @unicode.char2codepoint('㐀')
  end
  def test_extension
    assert !@unicode.extension?('一')
    assert !@unicode.extension?('㐀')
    assert @unicode.extension?('𠀀')
  end
  def test_extension_regexp
#    sample = "𠀀𪛖𪜀𫜴𫝀𫠝"
    assert_equal nil, @unicode.extension_regexp =~ "a"
    assert_equal 1, @unicode.extension_regexp =~ "x𠀀"
    assert_equal 2, @unicode.extension_regexp =~ "xx𠀀"
    assert_equal 3, @unicode.extension_regexp =~ "空𠀀" # 3 bytes
    assert_equal 6, @unicode.extension_regexp =~ "空空𠀀" # 6 bytes
    match = @unicode.extension_regexp.match("空𠀀白")
    assert_equal "空𠀀白", match.string
    assert_equal "空", match.pre_match
    assert_equal "𠀀", match[0]
    assert_equal "白", match.post_match
  end
end
