require File.join(File.dirname(__FILE__), '..', 'lib', 'tex_commands')
require 'test/unit'

class TeXCommandsTest < Test::Unit::TestCase
  def setup
    @commands = TeXCommands.new
  end
  def test_insert_extensions
    assert_equal "", @commands.insert_extensions("")
    assert_equal "", @commands.insert_extensions(nil)
    assert_equal "a", @commands.insert_extensions("a")
    assert_equal "㐀", @commands.insert_extensions("㐀")
    assert_equal "{\\ext 𠀀}", @commands.insert_extensions("𠀀")
    assert_equal "a{\\ext 𠀀}", @commands.insert_extensions("a𠀀")
    assert_equal "{\\ext 𠀀}a", @commands.insert_extensions("𠀀a")
    assert_equal "{\\ext 𠀀}㐀{\\ext 𠀀}", @commands.insert_extensions("𠀀㐀𠀀")
    assert_equal "{\\ext 𠀀}{\\ext 𪛖}{\\ext 𪜀}{\\ext 𫜴}{\\ext 𫝀}{\\ext 𫠝}",
      @commands.insert_extensions("𠀀𪛖𪜀𫜴𫝀𫠝")
  end
end
