require File.join(File.dirname(__FILE__), '..', 'lib', 'sw_seals')
require 'test/unit'

class SWSealsTest < Test::Unit::TestCase
  def setup
    @sw_seals = SWSeals.new
  end
  def test_wordid2char
    assert_equal '一', @sw_seals.wordid2char('0010010')
    assert_equal '丁', @sw_seals.wordid2char('0010011')
  end
  def test_get_char
    assert_equal '一', @sw_seals.get_char('w0010010')
    assert_equal '丁', @sw_seals.get_char('w0010011')
  end
  def test_variant?
    assert !@sw_seals.variant?('w0010010')
    assert @sw_seals.variant?('w0010011')
  end
  def test_get_duan_seal
    assert_equal '上', @sw_seals.get_duan_seal('w0020010')
    assert @sw_seals.get_duan_seal('w0020010')
    assert !@sw_seals.get_duan_seal('w0020011')
  end
end
