# -*- coding: utf-8 -*-
require 'rubygems'
require 'citrus'
require 'test/unit'

COMMANDS = File.join(File.dirname(__FILE__), '..', 'lib', 'commands')

class CommandsTest < Test::Unit::TestCase
  def setup
    Citrus.load COMMANDS
  end
  def assert_parse(string, root)
    match = Commands.parse(string, :root => root)
    assert(match)
    assert_equal(string, match)
  end
  def assert_parse_error(string, root)
    assert_raise Citrus::ParseError do
      Commands.parse(string, :root => root)
    end
  end
  def test_chapter
#    swbook = "[ch:一部]"
    swbook = "(ch 一部)"
    match = Commands.parse(swbook, :root => :command)
    assert(match)
    assert_equal(swbook, match)
    assert_equal("ch", match.name)
    assert_equal("\\chap{一部}", match.value)
  end
  def test_book
#    swbook = "[bk:説文]"
    swbook = "(bk 説文)"
    match = Commands.parse(swbook, :root => :command)
    assert(match)
    assert_equal(swbook, match)
    assert_equal("bk", match.name)
    assert_equal("\\book{説文}", match.value)

#    aswbook = "a[bk:説文]"
    aswbook = "a(bk 説文)"
    match = Commands.parse(aswbook, :root => :phrase)
    assert(match)
    assert_equal(aswbook, match)
    assert_equal("a\\book{説文}", match.value)

#    aswbook = "[bk:説文]曰"
    aswbook = "(bk 説文)曰"
    match = Commands.parse(aswbook, :root => :phrase)
    assert(match)
    assert_equal(aswbook, match)
    assert_equal("\\book{説文}曰", match.value)

#    swphrase = "[bk:説文]，形書也"
    swphrase = "(bk 説文)，形書也"
    match = Commands.parse(swphrase, :root => :phrase)
    assert_equal(swphrase, match)
    assert_equal("\\book{説文}，形書也", match.value)

    phrase = "aa(bk bb)ccc"
    match = Commands.parse(phrase, :root => :phrase)
    assert_equal(phrase, match)
    assert_equal("aa\\book{bb}ccc", match.value)
  end
end
