/*
 * Copyright (C) 2007 uguu at users.sourceforge.jp, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.deployer;

import java.io.File;

/**
 * <p>
 * {@link Deployer}クラスによるファイル配置のイベントを受け取るリスナーです。
 * </p>
 * 
 * @author $Author$
 * @version $Rev$ $Date$
 */
public interface DeployerListener {

    /**
     * <p>
     * アーカイブ・ファイルの配置を開始するときに呼び出されます。
     * </p>
     * 
     * @param deployer
     *            イベントの通知元の{@link Deployer}インスタンス。
     * @param file
     *            配置するアーカイブ・ファイル。
     */
    void deployStart(Deployer deployer, File file);

    /**
     * <p>
     * アーカイブ・ファイルから抽出したファイルを配置するときに呼び出されます。
     * </p>
     * 
     * @param deployer
     *            イベントの通知元の{@link Deployer}インスタンス。
     * @param file
     *            配置するアーカイブ・ファイル。
     * @param destDirectory
     *            配置先のルート・ディレクトリ。
     * @param deployFile
     *            配置するファイル。
     */
    void deployFile(Deployer deployer, File file, File destDirectory, File deployFile);

    /**
     * <p>
     * アーカイブ・ファイルの配置が終了したときに呼び出されます。
     * </p>
     * 
     * @param deployer
     *            イベントの通知元の{@link Deployer}インスタンス。
     * @param file
     *            配置したアーカイブ・ファイル。
     * @param destDirectory
     *            配置先のルート・ディレクトリ。
     */
    void deployEnd(Deployer deployer, File file, File destDirectory);

    /**
     * <p>
     * アーカイブ・ファイルの配置の解除を開始するときに呼び出されます。
     * </p>
     * 
     * @param deployer
     *            イベントの通知元の{@link Deployer}インスタンス。
     * @param file
     *            配置解除するアーカイブ・ファイル。
     * @param destDirectory
     *            配置先のルート・ディレクトリ。
     */
    void undeployStart(Deployer deployer, File file, File destDirectory);

    /**
     * アーカイブ・ファイルの配置の解除が終了したときに呼び出されます。
     * 
     * @param deployer
     *            イベントの通知元の{@link Deployer}インスタンス。
     * @param file
     *            配置解除したアーカイブ・ファイル。
     */
    void undeployEnd(Deployer deployer, File file);

}
