/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jp.sourceforge.deployer.FileMonitorFailException;
import jp.sourceforge.deployer.FileMonitorListener;
import jp.sourceforge.deployer.Message;

public final class FileMonitor {
    private List<FileMonitorListener> _listenerList = new ArrayList<FileMonitorListener>();
    private File _baseDirectory;
    private Pattern _filePattern;
    private Map<String, MonitoringFileInfo> _monitoringFileMap = new HashMap<String, MonitoringFileInfo>();
    private boolean _checkLength = true;
    private boolean _checkLastModified = true;
    private boolean _checkContent;
    private String _hashAlgorithm = "MD5";

    public FileMonitor(File baseDirectory, Pattern filePattern) {
        if (baseDirectory == null) {
            throw new IllegalArgumentException(Message.argumentIsNull("baseDirectory"));
        }
        if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException(Message.argumentIsNotDirectory("baseDirectory"));
        }
        if (filePattern == null) {
            throw new IllegalArgumentException(Message.argumentIsNull("filePattern"));
        }
        this._baseDirectory = baseDirectory;
        this._filePattern = filePattern;
    }

    public FileMonitor(File baseDirectory) {
        this(baseDirectory, Pattern.compile(".*"));
    }

    public boolean isCheckLength() {
        return this._checkLength;
    }

    public void setCheckLength(boolean checkLength) {
        this._checkLength = checkLength;
    }

    public boolean isCheckLastModified() {
        return this._checkLastModified;
    }

    public void setCheckLastModified(boolean checkLastModified) {
        this._checkLastModified = checkLastModified;
    }

    public boolean isCheckContent() {
        return this._checkContent;
    }

    public void setCheckContent(boolean checkContent) {
        this._checkContent = checkContent;
    }

    public String getHashAlgorithm() {
        return this._hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this._hashAlgorithm = hashAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FileMonitorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Message.argumentIsNull("listener"));
        }
        List<FileMonitorListener> list = this._listenerList;
        synchronized (list) {
            this._listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FileMonitorListener listener) {
        List<FileMonitorListener> list = this._listenerList;
        synchronized (list) {
            this._listenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMonitorListener[] getListeners() {
        List<FileMonitorListener> list = this._listenerList;
        synchronized (list) {
            return this._listenerList.toArray(new FileMonitorListener[0]);
        }
    }

    public void monitor() throws FileMonitorFailException {
        try {
            this.checkCreateOrUpdate(this._baseDirectory);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FileMonitorFailException(e);
        }
        catch (IOException e) {
            throw new FileMonitorFailException(e);
        }
        this.checkDelete();
        this.checkClear();
    }

    private void checkCreateOrUpdate(File dir) throws IOException, NoSuchAlgorithmException {
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isFile()) {
                this.checkFileCreateOrUpdate(f);
                continue;
            }
            this.checkCreateOrUpdate(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileCreateOrUpdate(File file) throws NoSuchAlgorithmException, IOException {
        if (this._filePattern.matcher(file.getAbsolutePath()).matches()) {
            Map<String, MonitoringFileInfo> map = this._monitoringFileMap;
            synchronized (map) {
                if (!this._monitoringFileMap.containsKey(file.getAbsolutePath())) {
                    FileMonitorListener[] listeners;
                    MonitoringFileInfo info = new MonitoringFileInfo();
                    info.path = file.getAbsolutePath();
                    this.setMonitoringFileInfo(file, info);
                    info.checked = true;
                    this._monitoringFileMap.put(file.getAbsolutePath(), info);
                    for (FileMonitorListener l : listeners = this.getListeners()) {
                        l.create(this, file);
                    }
                } else {
                    MonitoringFileInfo info = this._monitoringFileMap.get(file.getAbsolutePath());
                    if (this.isModified(file, info)) {
                        FileMonitorListener[] listeners;
                        this.setMonitoringFileInfo(file, info);
                        for (FileMonitorListener l : listeners = this.getListeners()) {
                            l.update(this, file);
                        }
                    }
                    info.checked = true;
                }
            }
        }
    }

    private boolean isModified(File file, MonitoringFileInfo info) throws NoSuchAlgorithmException, IOException {
        if (this._checkLength && file.length() != info.length) {
            return true;
        }
        if (this._checkLastModified && file.lastModified() != info.lastModified) {
            return true;
        }
        return this._checkContent && !Arrays.equals(this.getHashData(file), info.hashData);
    }

    private void setMonitoringFileInfo(File file, MonitoringFileInfo info) throws NoSuchAlgorithmException, IOException {
        if (this._checkLength) {
            info.length = file.length();
        }
        if (this._checkLastModified) {
            info.lastModified = file.lastModified();
        }
        if (this._checkContent) {
            MonitoringFileInfo.access$402(info, this.getHashData(file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getHashData(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(this._hashAlgorithm);
        FileInputStream fileIn = new FileInputStream(file);
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = fileIn.read(buf)) != -1) {
                md.update(buf, 0, len);
            }
        }
        finally {
            fileIn.close();
        }
        return md.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDelete() {
        Map<String, MonitoringFileInfo> map = this._monitoringFileMap;
        synchronized (map) {
            ArrayList<String> removeFileList = new ArrayList<String>();
            for (MonitoringFileInfo info : this._monitoringFileMap.values()) {
                FileMonitorListener[] listeners;
                File f;
                if (info.checked || (f = new File(info.path)).exists()) continue;
                removeFileList.add(info.path);
                for (FileMonitorListener l : listeners = this.getListeners()) {
                    l.delete(this, f);
                }
            }
            for (String path : removeFileList) {
                this._monitoringFileMap.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClear() {
        Map<String, MonitoringFileInfo> map = this._monitoringFileMap;
        synchronized (map) {
            for (MonitoringFileInfo info : this._monitoringFileMap.values()) {
                info.checked = false;
            }
        }
    }

    private class MonitoringFileInfo {
        private String path;
        private long length;
        private long lastModified;
        private byte[] hashData;
        private boolean checked;

        MonitoringFileInfo() {
        }

        static /* synthetic */ byte[] access$402(MonitoringFileInfo x0, byte[] x1) {
            x0.hashData = x1;
            return x1;
        }
    }
}

