//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on Sep-30, 2012.
//
#ifndef DCTOOLWINDOWTERMINALFROMAXONEDITOR_H
#define DCTOOLWINDOWTERMINALFROMAXONEDITOR_H

#include "dctoolwindowbase.h"

#include <QtGui>

class DCCreator;
class DCCell;
class DCEditableLabel;
class DCEditableTreeView;
class DCQtItemModel;

class DCToolWindowTerminalFromAxon : public DCToolWindowBase
{
    Q_OBJECT
private:
    DCCell              *d_axonCell;
    DCCell              *d_receptorCell;
    QString             d_receptorPagePath;
    DCEditableLabel     *d_textAxonCellName;
    DCEditableLabel     *d_textAxonCellPath;
    DCEditableLabel     *d_textReceptorCellName;
    DCEditableLabel     *d_textReceptorCellPath;

    DCEditableTreeView  *d_receptorCellReceptors;
    DCQtItemModel       *d_receptorCellReceptorItemModel;
    QGridLayout         *d_layout;


public:
    explicit DCToolWindowTerminalFromAxon(DCCreator *creator);
    virtual ~DCToolWindowTerminalFromAxon();
    
    virtual int getPosPriority() const { return 2; }
    DCCell*     getAxonCell() const { return d_axonCell; }
    DCCell*     getReceptorCell() const { return d_receptorCell; }

    void        updateData(DCCell *axonCell, const QString &receptorPagePath, DCCell *receptorCell);

signals:
    
public slots:
    
};

#endif // DCTOOLWINDOWTERMINALFROMAXONEDITOR_H
